package com.biz.crm.customermaterial.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.GlobalDictConstants;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.mapper.MdmCusOrgMapper;
import com.biz.crm.customermaterial.mapper.MdmCustomerMaterialMapper;
import com.biz.crm.customermaterial.model.MdmCustomerMaterialEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.mdm.MdmCusMaterialException;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.customermaterial.service.impl
 * @ClassName MdmCustomerMaterialServiceHelper
 * @Author HuangLong
 * @Date 2020/9/3 13:47
 * @Description 客户物料工具类
 */
@Component
@Slf4j
public class MdmCustomerMaterialServiceHelper {

    @Resource
    private MdmCustomerMaterialMapper customerMaterialMapper;
    @Resource
    private MdmCusOrgMapper cusOrgMapper;
    @Resource
    private MdmMaterialMapper materialMapper;

    public Map<String, Map<String, String>> getProductDict(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(GlobalDictConstants.ENABLE_STATUS);
        //查询字典数据
        Map<String, Map<String, String>> map = DictUtil.getDictValueMapsByCodes(dictCodes);
        return map;
    }
    /**
     * 转换商品列表数据
     * @param list
     */
    public void convertListDate(List<MdmCustomerMaterialRespVo> list){
        if(CollectionUtils.isNotEmpty(list)){
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getProductDict();
            list.forEach(o->{
                //启用禁用状态
                if(Objects.nonNull(o.getEnableStatus())){
                    o.setEnableStatusName(Optional.ofNullable(map.get(GlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
                }
            });
        }
    }

    /**
     * 客户物料新增,编辑,校验
     * @param reqVo
     */
    public void saveCheck(MdmCustomerMaterialReqVo reqVo){
        //校验数据不为空
        AssertUtils.isNotEmpty(reqVo.getCustomerOrgCode(),"客户组织编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getMaterialCode(),"物料编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getBarCode(),"条形码不能为空");
        //校验客户组织的数据有效性
        List<MdmCusOrgEntity> cusOrgEntities = cusOrgMapper.selectList(new LambdaQueryWrapper<MdmCusOrgEntity>().eq(MdmCusOrgEntity::getCustomerOrgCode, reqVo.getCustomerOrgCode()));
        AssertUtils.isTrue(CollectionUtils.isNotEmpty(cusOrgEntities),"您选择的客户组织数据不存在,请重新选择");
        AssertUtils.isTrue(cusOrgEntities.size()==1,"您选择的客户组织数据编码不唯一,请联系管理员处理");
        AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),cusOrgEntities.get(0).getEnableStatus()),"您选择的客户组织数据已被禁用");
        //校验物料的数据有效性
        List<MdmMaterialEntity> mdmMaterialEntities = materialMapper.selectList(new LambdaQueryWrapper<MdmMaterialEntity>().eq(MdmMaterialEntity::getMaterialCode, reqVo.getMaterialCode()));
        AssertUtils.isTrue(CollectionUtils.isNotEmpty(mdmMaterialEntities),"您选择的物料数据不存在,请重新选择");
        AssertUtils.isTrue(mdmMaterialEntities.size()==1,"您选择的物料数据编码不唯一,请联系管理员处理");
        AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),mdmMaterialEntities.get(0).getEnableStatus()),"您选择的物料数据已被禁用");
        this.checkDataExist(reqVo);
    }
    /**
     * 校验客户物料数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(MdmCustomerMaterialReqVo reqVo ) {
        QueryWrapper<MdmCustomerMaterialEntity> wrapper = new QueryWrapper<MdmCustomerMaterialEntity>().eq("customer_org_code", reqVo.getCustomerOrgCode()).eq("material_code", reqVo.getMaterialCode());
        List<MdmCustomerMaterialEntity> list = customerMaterialMapper.selectList(wrapper).stream().filter(x -> StringUtils.isEmpty(reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException(MdmCusMaterialException.DATA_DUPLICATE);
        }
    }
}
