package com.biz.crm.dict.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.nebular.mdm.dict.req.MdmDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;

import java.util.List;

/**
 * 数据字典扩展字段配置表接口
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
public interface MdmDictAttrConfService extends IService<MdmDictAttrConfEntity> {

    /**
     * 列表
     *
     * @param dictTypeCode
     * @return
     */
    List<MdmDictAttrConfRespVo> findList(String dictTypeCode);

    /**
     * 查询
     *
     * @param id
     * @return
     */
    MdmDictAttrConfRespVo detail(String id);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmDictAttrConfReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     */
    void update(MdmDictAttrConfReqVo reqVo);

    /**
     * 删除
     *
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据字典类型编码删除扩展字段配置
     *
     * @param dictTypeCode
     */
    void deleteByDictTypeCode(String dictTypeCode);

}

