package com.biz.crm.employeedirectory.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.employeedirectory.service.MdmEmployeeDirectoryService;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryListRespVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryReqVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author yangshan
 * @date 2021/3/5 14:46
 */
@RestController
@Slf4j
@RequestMapping("/mdmEmployeeDirectoryController")
@Api(tags = "员工通讯录")
@CrmGlobalLog
public class MdmEmployeeDirectoryController {

    @Autowired
    private MdmEmployeeDirectoryService mdmEmployeeDirectoryService;

    @ApiOperation(value = "查询列表")
    @PostMapping("/findList")
    @CrmDictMethod
    public Result<List<MdmEmployeeDirectoryListRespVo>> findList(){
        List<MdmEmployeeDirectoryListRespVo> list = mdmEmployeeDirectoryService.findList();
        return Result.ok(list);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmDictMethod
    public Result save(@RequestBody MdmEmployeeDirectoryReqVo reqVo){
        mdmEmployeeDirectoryService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "删除（按照人员编码）")
    @PostMapping("/deleteEmployeeCode")
    @CrmDictMethod
    public Result deleteEmployeeCode(@RequestBody List<String> employeeCodes){
        mdmEmployeeDirectoryService.deleteEmployeeCode(employeeCodes);
        return Result.ok();
    }

    @ApiOperation(value = "删除（按照职位编码）")
    @PostMapping("/deleteByPosCode")
    @CrmDictMethod
    public Result deleteByPosCode(@RequestBody List<String> posCodes){
        mdmEmployeeDirectoryService.deleteByPosCode(posCodes);
        return Result.ok();
    }



}
