package com.biz.crm.function.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionPermissionVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 菜单表
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
public interface MdmFunctionMapper extends BaseMapper<MdmFunctionEntity> {
    /**
     * 列表
     *
     * @param page             page
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> findList(Page<MdmFunctionRespVo> page, @Param("vo") MdmFunctionReqVo mdmFunctionReqVo);


    /**
     * 模块菜单树列表
     *
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmRoleFunctionTreeVo> roleFunctionTree(@Param("vo") MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询菜单懒加载数据
     *
     * @param enableStatus 启用状态
     * @param topOnly      传true只查第一层
     * @param parentCode   只查询该编码下一级
     * @param codeList     只查询这些编码
     * @return list
     */
    List<BaseLazyTreeRespVo> findFunctionLazyTreeList(@Param("enableStatus") String enableStatus, @Param("topOnly") Boolean topOnly, @Param("parentCode") String parentCode, @Param("codeList") List<String> codeList);

    /**
     * 查询菜单部分字段
     *
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> findSimpleList(@Param("vo") MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询菜单按钮
     * @return list
     */
    List<MdmFunctionPermissionVo> findFunctionCodeList(@Param("vo") MdmFunctionReqVo mdmFunctionReqVo);
}
