package com.biz.crm.function.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.function.model.MdmFunctionRoleEntity;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleReqVo;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 菜单-角色关联表
 * 
 * @author zxw
 * @date 2020-11-18 10:42:36
 */
public interface MdmFunctionRoleMapper extends BaseMapper<MdmFunctionRoleEntity> {
    /**
     * 列表
     * @param page
     * @param mdmFunctionRoleReqVo
     * @return
     */
    List<MdmFunctionRoleRespVo> findList(Page<MdmFunctionRoleRespVo> page, @Param("vo") MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 根据职位查询角色编码与菜单编码集合
     * @param positionCode 职位编码
     * @return list
     */
    List<MdmFunctionRoleEntity> findFunctionCodeByPositionCode(@Param("positionCode") String positionCode);
}
