package com.biz.crm.function.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.function.model.MdmFunctionRoleEntity;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleReqVo;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleRespVo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * 职位级别-角色关联表接口
 *
 * @author zxw
 * @date 2020-11-18 10:42:36
 */
public interface MdmFunctionRoleService extends IService<MdmFunctionRoleEntity> {

    /**
     * 列表
     * @param mdmFunctionRoleReqVo
     * @return PageResult<MdmFunctionRoleRespVo>
     */
    PageResult<MdmFunctionRoleRespVo> findList(MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 查询
     * @param mdmFunctionRoleReqVo
     * @return MdmFunctionRoleRespVo
     */
    MdmFunctionRoleRespVo query(MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 新增
     * @param mdmFunctionRoleReqVo
     * @return
     */
    void save(MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 更新
     * @param mdmFunctionRoleReqVo
     * @return
     */
    void update(MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    @Transactional
    void deleteByRoleCodeList(List<String> roleCodeList);

    /**
     * 删除
     * @param mdmFunctionRoleReqVo
     * @return
     */
    void deleteBatch(MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 查询角色关联的菜单编码
     * @param roleCode
     * @return
     */
    List<String> findFunctionCodeByRole(String roleCode);

    List<String> findFunctionCodeByRole(List<String> roleCodeList);

    /**
     * 查询菜单关联的角色编码
     * @param functionCode 菜单编码
     * @return
     */
    List<String> findRoleCodeByFunction(String functionCode);

    /**
     * 角色与菜单关联关系修改
     * @param roleCode 角色编码
     * @param functionCodeList 菜单编码列表
     */
    void update(String roleCode, List<String> functionCodeList);

    /**
     * 根据职位查询角色编码与菜单编码集合
     * @param positionCode 职位编码
     * @return list
     */
    List<MdmFunctionRoleEntity> findFunctionCodeByPositionCode(String positionCode);
}

