package com.biz.crm.icon.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.icon.service.IMdmIconService;
import com.biz.crm.nebular.mdm.icon.MdmIconReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zxw
 * @date 2020-12-05 11:10:24
 */
@Slf4j
@RestController
@RequestMapping("/mdmicon")
@Api(tags = "图标管理")
@CrmGlobalLog
public class MdmIconController {
    @Autowired
    private IMdmIconService mdmIconService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmIconRespVo>> list(@RequestBody MdmIconReqVo mdmIconReqVo) {
        PageResult<MdmIconRespVo> result = mdmIconService.findList(mdmIconReqVo);
        return Result.ok(result);
    }

    @ApiOperation("列表查询")
    @PostMapping("/listCondition")
    public Result<List<MdmIconRespVo>> listCondition(@RequestBody MdmIconReqVo mdmIconReqVo) {
        List<MdmIconRespVo> list = mdmIconService.listCondition(mdmIconReqVo);
        return Result.ok(list);
    }

    @ApiImplicitParams({
         @ApiImplicitParam(name = "id", value = "id", required = false, paramType = "query"),
         @ApiImplicitParam(name = "iconCode", value = "图标编码", required = false, paramType = "query"),
    })
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmIconRespVo> query(@RequestParam(value = "id",required = false) String id,
                                       @RequestParam(value = "iconCode",required = false) String iconCode) {
        MdmIconRespVo respVo = mdmIconService.query(id,iconCode);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmIconReqVo mdmIconReqVo) {
        mdmIconService.save(mdmIconReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmIconReqVo mdmIconReqVo) {
        mdmIconService.update(mdmIconReqVo);
        return Result.ok("修改成功");
    }

    @ApiImplicitParams({
         @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        mdmIconService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        mdmIconService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        mdmIconService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
