package com.biz.crm.kms.controller;

import com.biz.crm.kms.service.KmsOrderService;
import com.biz.crm.nebular.mdm.kms.api.KmsOrderDetailVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-28 22:43
 **/
@RestController
@RequestMapping("/KmsOrderController")
@Api(tags = "kms单据")
public class KmsOrderController {

    @Resource
    private KmsOrderService kmsOrderService;

    @ApiOperation("验收单")
    @GetMapping("/fetchAcceptanceOrder")
    public Result<Object> fetchAcceptanceOrder() {
        kmsOrderService.fetchAcceptanceOrder();
        return Result.ok();
    }

    @ApiOperation("订货单")
    @GetMapping("/fetchIndentOrder")
    public Result<Object> fetchIndentOrder() {
        kmsOrderService.fetchIndentOrder();
        return Result.ok();
    }

    @ApiOperation("退货单")
    @GetMapping("/fetchReturnOrder")
    public Result<Object> fetchReturnOrder() {
        kmsOrderService.fetchReturnOrder();
        return Result.ok();
    }

    @ApiOperation("订单详情")
    @PostMapping("/obtainDetails")
    public List<KmsOrderDetailVo> obtainDetails(@RequestParam String orderNumber,@RequestParam String bsInvoiceId) {
        return kmsOrderService.obtainDetails(orderNumber, bsInvoiceId);
    }
}
