package com.biz.crm.kms.controller;

import com.biz.crm.kms.service.MdmCategoryService;
import com.biz.crm.nebular.mdm.kms.api.KmsCategoryVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 产品分类
 *
 * @author zxw
 * @date 2021-03-08 14:54
 **/
@RestController
@RequestMapping("/mdmCategoryController")
@Api(tags = "kms产品分类")
public class MdmCategoryController {

    @Resource
    private MdmCategoryService mdmCategoryService;

    @ApiOperation("新增产品分类")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody KmsCategoryVo kmsCategoryVo) {
        mdmCategoryService.add(kmsCategoryVo);
        return Result.ok();
    }

    @ApiOperation("批量新增")
    @PostMapping("/addBatch")
    public Result<Object> addBatch(@RequestBody List<MdmProductLevelReqVo> list) {
        mdmCategoryService.addBatch(list);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestParam String productLevelCode) {
        mdmCategoryService.remove(productLevelCode);
        return Result.ok(productLevelCode);
    }

    @ApiOperation("同步产品层级树到kms")
    @PostMapping("/sync")
    public Result<Object> sync() {
        mdmCategoryService.productLevelSync();
        return Result.ok();
    }

    @ApiOperation("清空kms产品层级树")
    @PostMapping("/clear")
    public Result<Object> clear() {
        mdmCategoryService.productLevelClear();
        return Result.ok();
    }
}
