package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.kms.service.MdmSellPartyService;
import com.biz.crm.nebular.mdm.kms.MdmSellPartyVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 售达方控制器
 *
 * @author zxw
 * @date 2021-02-19 10:45
 **/
@RestController
@RequestMapping("/mdmSellPartyController")
@CrmGlobalLog
@Api(tags = "kms售达方")
public class MdmSellPartyController {

    @Resource
    private MdmSellPartyService mdmSellPartyService;

    @PostMapping("/page")
    @ApiOperation("售达方分页查询")
    public Result<PageResult<MdmSellPartyVo>> page(@RequestBody MdmSellPartyVo mdmSellPartyVo) {
        return Result.ok(mdmSellPartyService.page(mdmSellPartyVo));
    }

    @ApiOperation("售达方列表")
    @PostMapping("/list")
    public Result<List<MdmSellPartyVo>> list(@RequestBody MdmSellPartyVo mdmSellPartyVo) {
        return Result.ok(mdmSellPartyService.list(mdmSellPartyVo));
    }

    @ApiOperation("新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmSellPartyVo mdmSellPartyVo) {
        mdmSellPartyService.save(mdmSellPartyVo);
        return Result.ok();
    }

    @ApiOperation("编辑")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmSellPartyVo mdmSellPartyVo) {
        mdmSellPartyService.update(mdmSellPartyVo);
        return Result.ok();
    }

    @ApiOperation("批量删除")
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        mdmSellPartyService.delete(ids);
        return Result.ok();
    }

    @ApiOperation("启用")
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        mdmSellPartyService.enable(ids);
        return Result.ok();
    }

    @ApiOperation("禁用")
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        mdmSellPartyService.disable(ids);
        return Result.ok();
    }
}
