package com.biz.crm.kms.manager;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.KmsInvoiceSourceEnum;
import com.biz.crm.kms.model.*;
import com.biz.crm.nebular.mdm.kms.*;
import com.biz.crm.nebular.mdm.kms.api.*;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zxw
 */
@Mapper
public interface KmsConverter {

    String ENABLE = "ENABLE";

    String DISABLE = "DISABLE";

    default String enableConverter(KmsDirectSystemVo kmsDirectSystemVo) {
        if (ENABLE.equals(kmsDirectSystemVo.getComomStatus())) {
            return "009";
        } else if (DISABLE.equals(kmsDirectSystemVo.getComomStatus())) {
            return "003";
        }
        return null;
    }

    default String enableNameConverter(KmsDirectSystemVo kmsDirectSystemVo) {
        if (ENABLE.equals(kmsDirectSystemVo.getComomStatus())) {
            return "启用";
        } else if (DISABLE.equals(kmsDirectSystemVo.getComomStatus())) {
            return "禁用";
        }
        return null;
    }

    KmsConverter INSTANCE = Mappers.getMapper(KmsConverter.class);

    @Mapping(target = "directSystemId", source = "id")
    @Mapping(target = "enableStatus", expression = "java(enableConverter(kmsDirectSystemVo))")
    @Mapping(target = "enableStatusName", expression = "java(enableNameConverter(kmsDirectSystemVo))")
    MdmDirectSystemVo directSystem2Mdm(KmsDirectSystemVo kmsDirectSystemVo);

    List<MdmDirectSystemVo> directSystem2Mdm(List<KmsDirectSystemVo> kmsDirectSystemVo);


    default String enableConverter(MdmSellPartyVo mdmSellPartyVo) {
        if ("009".equals(mdmSellPartyVo.getEnableStatus())) {
            return ENABLE;
        } else if ("003".equals(mdmSellPartyVo.getEnableStatus())) {
            return DISABLE;
        }
        return null;
    }

    @Mapping(target = "notes", source = "remarks")
    @Mapping(target = "status", expression = "java(enableConverter(mdmSellPartyVo))")
    KmsSellPartyVo mdm2SellParty(MdmSellPartyVo mdmSellPartyVo);

    default String enableConverter(KmsSellPartyVo kmsSellPartyVo) {
        if (ENABLE.equals(kmsSellPartyVo.getStatus())) {
            return "009";
        } else if (DISABLE.equals(kmsSellPartyVo.getStatus())) {
            return "003";
        }
        return null;
    }

    default String enableNameConverter(KmsSellPartyVo kmsSellPartyVo) {
        if (ENABLE.equals(kmsSellPartyVo.getStatus())) {
            return "启用";
        } else if (DISABLE.equals(kmsSellPartyVo.getStatus())) {
            return "禁用";
        }
        return null;
    }

    @Mapping(target = "enableStatus", expression = "java(enableConverter(kmsSellPartyVo))")
    @Mapping(target = "enableStatusName", expression = "java(enableNameConverter(kmsSellPartyVo))")
    @Mapping(target = "remarks", source = "notes")
    MdmSellPartyVo sellParty2Mdm(KmsSellPartyVo kmsSellPartyVo);

    List<MdmSellPartyVo> sellParty2Mdm(List<KmsSellPartyVo> kmsSellPartyVo);

    @Mapping(target = "count", source = "records")
    @Mapping(target = "data", source = "rows")
    PageResult<MdmSellPartyVo> sellPartyPage(KmsPageResultVo<KmsSellPartyVo> mdmSellPartyVoKmsPageResultVo);

    @Mapping(target = "remark", source = "remarks")
    KmsCustomerAccountVo customerAccount2Kms(MdmCustomerAccountVo mdmCustomerAccountVo);

    @Mapping(target = "remarks", source = "remark")
    MdmCustomerAccountVo customerAccount2Mdm(KmsCustomerAccountVo kmsCustomerAccountVo);

    List<MdmCustomerAccountVo> customerAccount2Mdm(List<KmsCustomerAccountVo> kmsCustomerAccountVo);

    @Mapping(target = "count", source = "records")
    @Mapping(target = "data", source = "rows")
    PageResult<MdmCustomerAccountVo> customerAccountPage(KmsPageResultVo<KmsCustomerAccountVo> kmsCustomerAccountVoKmsPageResultVo);

    @Mapping(target = "orderUnitId", source = "id")
    @Mapping(target = "orderUnit", source = "unitName")
    MdmProductUnitVo productUnit2Mdm(KmsProductUnitVo kmsProductUnitVo);

    List<MdmProductUnitVo> productUnit2Mdm(List<KmsProductUnitVo> kmsProductUnitVos);

    @Mapping(target = "notes", source = "remarks")
    KmsProductVo product2Kms(MdmShelfProductVo mdmShelfProductVo);

    @Mapping(target = "remarks", source = "notes")
    MdmShelfProductVo product2Mdm(KmsProductVo kmsProductVos);

    List<MdmShelfProductVo> product2Mdm(List<KmsProductVo> kmsProductVos);

    @Mapping(target = "count", source = "records")
    @Mapping(target = "data", source = "rows")
    PageResult<MdmShelfProductVo> product2Mdm(KmsPageResultVo<KmsProductVo> pageResultVo);

    MdmGrabRuleVo grabRule2Mdm(KmsGrabRuleVo kmsGrabRuleVo);

    KmsGrabRuleVo grabRule2Kms(MdmGrabRuleVo kmsGrabRuleVo);

    List<MdmGrabRuleVo> grabRule2Mdm(List<KmsGrabRuleVo> kmsGrabRuleVos);

    @Mapping(target = "count", source = "records")
    @Mapping(target = "data", source = "rows")
    PageResult<MdmGrabRuleVo> grabRule2Mdm(KmsPageResultVo<KmsGrabRuleVo> kmsPageResultVo);

    default String convertInvoiceSource(KmsAcceptanceVoucherVo kmsAcceptanceVoucherVo) {
        return KmsInvoiceSourceEnum.findCodeByValue(kmsAcceptanceVoucherVo.getInvoicesSource());
    }

    @Mapping(target = "id", source = "orderNumber")
    @Mapping(target = "invoicesSource", expression = "java(convertInvoiceSource(kmsAcceptanceVoucherVos))")
    DmsAcceptanceVoucherEntity acceptance2entity(KmsAcceptanceVoucherVo kmsAcceptanceVoucherVos);

    List<DmsAcceptanceVoucherEntity> acceptance2entity(List<KmsAcceptanceVoucherVo> kmsAcceptanceVoucherVos);

    default String convertInvoiceSource(KmsIndentVoucherVo kmsIndentVoucherVo) {
        return KmsInvoiceSourceEnum.findCodeByValue(kmsIndentVoucherVo.getInvoicesSource());
    }

    @Mapping(target = "id", source = "orderNumber")
    @Mapping(target = "invoicesSource", expression = "java(convertInvoiceSource(kmsIndentVoucherVos))")
    DmsIndentVoucherEntity indent2entity(KmsIndentVoucherVo kmsIndentVoucherVos);

    List<DmsIndentVoucherEntity> indent2entity(List<KmsIndentVoucherVo> kmsIndentVoucherVos);

    default String convertInvoiceSource(KmsPriceVoucherVo kmsPriceVoucherVo) {
        return KmsInvoiceSourceEnum.findCodeByValue(kmsPriceVoucherVo.getInvoicesSource());
    }

    @Mapping(target = "id", source = "orderNumber")
    @Mapping(target = "invoicesSource", expression = "java(convertInvoiceSource(kmsPriceVoucherVos))")
    DmsPriceVoucherEntity price2entity(KmsPriceVoucherVo kmsPriceVoucherVos);

    List<DmsPriceVoucherEntity> price2entity(List<KmsPriceVoucherVo> kmsPriceVoucherVos);

    default String convertInvoiceSource(KmsReturnVoucherVo kmsReturnVoucherVo) {
        return KmsInvoiceSourceEnum.findCodeByValue(kmsReturnVoucherVo.getInvoicesSource());
    }

    @Mapping(target = "id", source = "kaOrderNumber")
    @Mapping(target = "invoicesSource", expression = "java(convertInvoiceSource(kmsReturnVoucherVos))")
    DmsReturnVoucherEntity return2entity(KmsReturnVoucherVo kmsReturnVoucherVos);

    List<DmsReturnVoucherEntity> return2entity(List<KmsReturnVoucherVo> kmsReturnVoucherVos);

    default String convertStatus(MdmProductReqVo mdmProductReqVo) {
        if (CrmEnableStatusEnum.DISABLE.getCode().equals(mdmProductReqVo.getEnableStatus())) {
            return DISABLE;
        }
        return ENABLE;
    }

    @Mapping(target = "id", source = "productCode")
    @Mapping(target = "description", source = "remarks")
    @Mapping(target = "packSize", source = "spec")
    @Mapping(target = "priceEndDate", source = "endDate")
    @Mapping(target = "priceStartDate", source = "beginDate")
    @Mapping(target = "proDetailsNumber", source = "productCode")
    @Mapping(target = "proDetailsName", source = "productName")
    @Mapping(target = "proDetailsStatus", expression = "java(convertStatus(mdmProductReqVo))")
    @Mapping(target = "proCategory", source = "productLevelCode")
    KmsProVo product2Kms(MdmProductReqVo mdmProductReqVo);

    @Mapping(target = "id", source = "rawDataId")
    KmsOrderDetailEntity order2Entity(KmsOrderDetailVo kmsOrderDetailVo);
}
