package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmCustomerAccountService;
import com.biz.crm.nebular.mdm.kms.MdmCustomerAccountVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-02-19 12:24
 **/
@Service
@ConditionalOnMissingBean(name = "MdmCustomerAccountServiceExpandImpl")
public class MdmCustomerAccountServiceImpl implements MdmCustomerAccountService {

    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public PageResult<MdmCustomerAccountVo> page(MdmCustomerAccountVo mdmCustomerAccountVo) {
        Integer current = Optional.ofNullable(mdmCustomerAccountVo.getPageNum()).orElse(1);
        if (current == 0) {
            current = 1;
        }
        Integer size = Optional.ofNullable(mdmCustomerAccountVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, -1);

        KmsCustomerAccountVo kmsCustomerAccountVo = new KmsCustomerAccountVo();
        String directSystemId = mdmCustomerAccountVo.getDirectSystemId();
        Assert.hasText(directSystemId, "直营体系id不能为空");
        kmsCustomerAccountVo.setDirectSystemId(directSystemId);
        kmsCustomerAccountVo.setTenantryId(kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setLoginAcc(mdmCustomerAccountVo.getLoginAcc());

        KmsCustomerAccountPageReqVo kmsCustomerAccountPageReqVo = new KmsCustomerAccountPageReqVo();
        kmsCustomerAccountPageReqVo.setPage(kmsPageVo);
        kmsCustomerAccountPageReqVo.setReqVo(kmsCustomerAccountVo);
        kmsCustomerAccountPageReqVo.setTenantryId(kmsProperties.getTenantryId());
        kmsCustomerAccountPageReqVo.setUserId(kmsProperties.getUserId());
        kmsCustomerAccountPageReqVo.setUsername(kmsProperties.getUsername());

        String url = kmsProperties.getUrl() + "/ruleAccountController/findRuleAccountListByPage";

        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsCustomerAccountVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsCustomerAccountVo>>>() {
        };

        ResponseEntity<KmsResultVo<KmsPageResultVo<KmsCustomerAccountVo>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, kmsCustomerAccountPageReqVo, reference);
        KmsPageResultVo<KmsCustomerAccountVo> kmsCustomerAccountVoKmsPageResultVo = Optional.ofNullable(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .orElse(null);
        if (kmsCustomerAccountVoKmsPageResultVo == null) {
            PageResult<MdmCustomerAccountVo> mdmCustomerAccountVoPageResult = new PageResult<>();
            mdmCustomerAccountVoPageResult.setCount(0L);
            mdmCustomerAccountVoPageResult.setData(new ArrayList<>());
            return mdmCustomerAccountVoPageResult;
        }
        PageResult<MdmCustomerAccountVo> mdmCustomerAccountVoPageResult = KmsConverter.INSTANCE.customerAccountPage(kmsCustomerAccountVoKmsPageResultVo);
        List<MdmCustomerAccountVo> originalData = mdmCustomerAccountVoPageResult.getData();
        if (CollectionUtils.isEmpty(originalData)) {
            return mdmCustomerAccountVoPageResult;
        }
        String loginAcc = mdmCustomerAccountVo.getLoginAcc();
        List<MdmCustomerAccountVo> realData = originalData.stream()
                .filter(x -> StringUtils.isEmpty(loginAcc) || x.getLoginAcc().contains(loginAcc))
                .skip((current - 1) * size)
                .limit(size)
                .peek(x -> {
                    x.setAccountId(x.getId());
                    x.setDirectSystemId(mdmCustomerAccountVo.getDirectSystemId());
                    x.setDirectSystemName(mdmCustomerAccountVo.getDirectSystemName());
                })
                .collect(Collectors.toList());
        mdmCustomerAccountVoPageResult.setData(realData);
        mdmCustomerAccountVoPageResult.setCount((long) originalData.size());
        return mdmCustomerAccountVoPageResult;
    }

    @Override
    public void save(MdmCustomerAccountVo mdmCustomerAccountVo) {
        mdmCustomerAccountVo.setId(null);
        Assert.hasText(mdmCustomerAccountVo.getLoginAcc(), "客户帐号不能为空");
        Assert.hasText(mdmCustomerAccountVo.getDirectSystemId(), "直营体系id不能为空");
        KmsCustomerAccountVo kmsCustomerAccountVo = KmsConverter.INSTANCE.customerAccount2Kms(mdmCustomerAccountVo);
        kmsCustomerAccountVo.setTenantryId(kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setUserId(kmsProperties.getUserId());
        kmsCustomerAccountVo.setUsername(kmsProperties.getUsername());

        String url = kmsProperties.getUrl() + "/ruleAccountController/saveRuleAccount?access_token=" + kmsProperties.getAccessToken();

        ResponseEntity<String> entity = RestTemplateUtils.postForEntity(url, null, kmsCustomerAccountVo, String.class);
        if (!HttpStatus.OK.equals(entity.getStatusCode())) {
            throw new BusinessException("新增失败");
        }
    }

    @Override
    public void update(MdmCustomerAccountVo mdmCustomerAccountVo) {
        Assert.hasText(mdmCustomerAccountVo.getId(), "id不能为空");
        Assert.hasText(mdmCustomerAccountVo.getLoginAcc(), "客户帐号不能为空");
        Assert.hasText(mdmCustomerAccountVo.getDirectSystemId(), "直营体系id不能为空");
        KmsCustomerAccountVo kmsCustomerAccountVo = KmsConverter.INSTANCE.customerAccount2Kms(mdmCustomerAccountVo);
        kmsCustomerAccountVo.setTenantryId(kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setUserId(kmsProperties.getUserId());
        kmsCustomerAccountVo.setUsername(kmsProperties.getUsername());

        String url = kmsProperties.getUrl() + "/ruleAccountController/saveRuleAccount?access_token=" + kmsProperties.getAccessToken();

        ResponseEntity<String> entity = RestTemplateUtils.postForEntity(url, null, kmsCustomerAccountVo, String.class);
        if (!HttpStatus.OK.equals(entity.getStatusCode())) {
            throw new BusinessException("修改失败");
        }
    }

    @Override
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, "id集合不能为空");
        for (String id : ids) {
            if (!StringUtils.isEmpty(id)) {
                KmsCustomerAccountVo kmsCustomerAccountVo = new KmsCustomerAccountVo();
                kmsCustomerAccountVo.setId(id);

                kmsCustomerAccountVo.setTenantryId(kmsProperties.getTenantryId());
                kmsCustomerAccountVo.setUserId(kmsProperties.getUserId());
                kmsCustomerAccountVo.setUsername(kmsProperties.getUsername());

                String url = kmsProperties.getUrl() + "/ruleAccountController/deleteRuleAccount?access_token=" + kmsProperties.getAccessToken();

                ResponseEntity<String> entity = RestTemplateUtils.postForEntity(url, null, kmsCustomerAccountVo, String.class);
                if (!HttpStatus.OK.equals(entity.getStatusCode())) {
                    throw new BusinessException("删除失败");
                }
            }
        }
    }

    @Override
    public List<KmsGrabStoreVo> findGrabStoreList(MdmGrabRuleVo mdmGrabRuleVo) {
        if (StringUtils.isEmpty(kmsProperties.getAccessToken())) {
            return new ArrayList<>();
        }
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        if (StringUtils.isEmpty(directSystemId)) {
            return new ArrayList<>();
        }

        Map<String, String> map = new HashMap<>();
        map.put("directSystemId", directSystemId);
        map.put("userId", kmsProperties.getUserId());
        map.put("username", kmsProperties.getUsername());
        map.put("tenantryId", kmsProperties.getTenantryId());

        String url = kmsProperties.getUrl() + "/storeController/bsStoreList";


        ParameterizedTypeReference<KmsResultVo<List<KmsBsStoreVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsBsStoreVo>>>() {
        };

        String storeName = mdmGrabRuleVo.getStoreName();

        ResponseEntity<KmsResultVo<List<KmsBsStoreVo>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, map, reference);
        return Optional.of(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .map(x ->
                        x.stream()
                                .filter(k -> StringUtils.isEmpty(storeName) || k.getBsStoreName().contains(storeName))
                                .map(k -> {
                                    KmsGrabStoreVo kmsGrabStoreVo = new KmsGrabStoreVo();
                                    kmsGrabStoreVo.setId(k.getBsStoreId());
                                    kmsGrabStoreVo.setName(k.getBsStoreName());
                                    return kmsGrabStoreVo;
                                }).collect(Collectors.toList())
                )
                .orElse(new ArrayList<>());

//        List<KmsGrabStoreVo> kmsGrabStoreVos = Optional.of(entity)
//                .map(HttpEntity::getBody)
//                .map(KmsResultVo::getData)
//                .orElse(new ArrayList<>());
//        //id重复过滤
//        List<KmsGrabStoreVo> collect = kmsGrabStoreVos.stream()
//                .filter(x-> x.isSelected())
//                .filter(distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
//        for (KmsGrabStoreVo kmsGrabStoreVo : collect) {
//            kmsGrabStoreVo.setChildList(distinctId(kmsGrabStoreVo.getChildList()));
//        }
//        String storeName = mdmGrabRuleVo.getStoreName();
//        if(!StringUtils.isEmpty(storeName)){
//            collect = convert(collect, storeName);
//        }
//        return collect;
    }

    private List<KmsGrabStoreVo> convert(List<KmsGrabStoreVo> collect, String storeName) {
        if (CollectionUtils.isEmpty(collect) || StringUtils.isEmpty(storeName)) {
            return collect;
        }
        for (KmsGrabStoreVo kmsGrabStoreVo : collect) {
            kmsGrabStoreVo.setChildList(convert(kmsGrabStoreVo.getChildList(), storeName));
        }
        return collect.stream()
                .filter(x -> !CollectionUtils.isEmpty(x.getChildList()) || x.getName().contains(storeName))
                .collect(Collectors.toList());
    }


    private List<KmsGrabStoreVo> distinctId(List<KmsGrabStoreVo> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return new ArrayList<>();
        }
        for (KmsGrabStoreVo kmsGrabStoreVo : childList) {
            kmsGrabStoreVo.setChildList(distinctId(kmsGrabStoreVo.getChildList()));
        }
        return childList.stream()
                .filter(x -> x.isSelected())
                .filter(distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }


}
