package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.*;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginAesUtil;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 登录控制器
 *
 * @author zxw
 * @date 2020-11-19 13:58
 **/
@RestController
@RequestMapping("/login")
@Api(tags = "登录控制器（过期）")
public class MdmLoginController {

    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmDmsMallLoginService mdmDmsMallLoginService;
    @Autowired
    private MdmSfaAppletLoginService mdmSfaAppletLoginService;
    @Autowired
    private MdmSfaAppLoginService mdmSfaAppLoginService;
    @Autowired
    private MdmDmsAppLoginService mdmDmsAppLoginService;
    @Autowired
    private MdmDmsAppletLoginService mdmDmsAppletLoginService;

    @ApiOperation("系统登录")
    @PostMapping("/system")
    @CrmLog
    public Result<MdmLoginRespVo> systemLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.CONSOLE.getValue());
        return Result.ok(mdmSystemLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("dms商城后台登录")
    @PostMapping("/dms_mall")
    public Result<MdmLoginRespVo> dmsMallLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.WEB_DMS.getValue());
        return Result.ok(mdmDmsMallLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("dmsAPP登录")
    @PostMapping("/dms_app")
    public Result<MdmLoginRespVo> dmsAppLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
//        mdmLoginReqVo.setFromType(LoginFromTypeEnum.APP_DMS.getValue());
//        return Result.ok(mdmDmsAppLoginService.login(mdmLoginReqVo));
        //TODO 本来是APP的接口，但是小程序调用了这个接口，暂时换成调用小程序的接口
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.APPLET_DMS.getValue());
        return Result.ok(mdmDmsAppletLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("dms微信小程序登录")
    @PostMapping("/dms_applet")
    public Result<MdmLoginRespVo> dmsAppletLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.APPLET_DMS.getValue());
        return Result.ok(mdmDmsAppletLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("sfa微信小程序登录（过期）")
    @PostMapping("/sfa_applet")
    public Result<MdmLoginRespVo> sfaAppletLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.APPLET_SFA.getValue());
        return Result.ok(mdmSfaAppLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("sfa微信小程序免密码登录（通过openId）")
    @PostMapping("/sfaAppletLoginByOpenId")
    public Result<MdmLoginRespVo> sfaAppletLoginByOpenId(@RequestBody MdmAppletLoginReqVo reqVo) {
        MdmLoginRespVo mdmLoginRespVo = null;
        try {
            reqVo.setFromType(LoginFromTypeEnum.APPLET_SFA.getValue());
            mdmLoginRespVo = mdmSfaAppletLoginService.loginByOpenId(reqVo);
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        } catch (Exception e) {
            mdmLoginRespVo = new MdmLoginRespVo();
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        return Result.ok(mdmLoginRespVo);
    }

    @ApiOperation("sfa微信小程序登录并绑定微信")
    @PostMapping("/sfaAppletLoginAndBind")
    public Result<MdmLoginRespVo> sfaAppletLoginAndBind(@RequestBody MdmAppletLoginReqVo reqVo) {
        reqVo.setFromType(LoginFromTypeEnum.APPLET_SFA.getValue());
        return Result.ok(mdmSfaAppletLoginService.login(reqVo));
    }

    @ApiOperation("sfaAPP登录")
    @PostMapping("/sfa_app")
    public Result<MdmLoginRespVo> sfaAppLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        revert(mdmLoginReqVo);
        mdmLoginReqVo.setFromType(LoginFromTypeEnum.APP_SFA.getValue());
        return Result.ok(mdmSfaAppLoginService.login(mdmLoginReqVo));
    }

    @ApiOperation("获取当前登录人信息")
    @GetMapping("/getNowUser")
    public Result<UserRedis> getNowUser() {
        Result<UserRedis> result = new Result<>();
        UserRedis userRedis = UserUtils.getUser();
        result.setResult(userRedis);
        return result;
    }

    @ApiOperation("退出登录")
    @GetMapping("/loginOut")
    public Result loginOut() {
        UserUtils.logout();
        return Result.ok();
    }

    /**
     * 把加密参数转换成已有参数
     *
     * @param reqVo
     * @return
     */
    private void revert(MdmLoginReqVo reqVo) {
        if (StringUtils.isNotEmpty(reqVo.getUjlrwebjruzddjnu())) {
            reqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty(reqVo.getPthxivgijazekrss())) {
            reqVo.setPassword(LoginAesUtil.decrypt(reqVo.getPthxivgijazekrss()));
        } else if (StringUtils.isNotEmpty(reqVo.getPazjofxkyvyoosot())) {
            reqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
        } else if (StringUtils.isNotEmpty(reqVo.getPenijmgsbybkfjvr())) {
            reqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        } else {

        }
        if (StringUtils.isNotEmpty(reqVo.getTwpbmjhfxodboggf())) {
            reqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty(reqVo.getExzvsxwhvcvcctyk())) {
            reqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty(reqVo.getVfymxygsefoeapvk())) {
            reqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
    }

}
