package com.biz.crm.login.controller;

import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.external.WeChatFeign;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginParamRespVo;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.weixin.OpenIdUtil;
import com.biz.crm.util.weixin.OpenIdVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

import javax.annotation.Resource;
import java.util.List;

/**
 * 登录控制参数获取类
 * 加入白名单，不用登录也可以请求
 *
 * @author Tao.Chen
 * @date 2021-02-19 11:47:07
 */
@RestController
@RequestMapping("/mdmLoginHelpController")
@Api(tags = "登录控制参数获取类（过期）")
public class MdmLoginHelpController {

    @Resource
    private WeChatFeign weChatFeign;

    @ApiOperation(value = "根据微信登录凭证获取sfa小程序openId", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "微信登录凭证", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/getSfaAppletOpenIdByCode")
    public Result<MdmAppletLoginParamRespVo> getSfaAppletOpenIdByCode(@RequestParam(value = "code", required = true) String code) {
        OpenIdVo openIdVo = OpenIdUtil.getSfaAppletOpenId(code);
        Assert.notNull(openIdVo, "获取openId失败");
        Assert.hasText(openIdVo.getOpenid(), "获取openId失败");
        MdmAppletLoginParamRespVo respVo = new MdmAppletLoginParamRespVo();
        respVo.setOpenId(openIdVo.getOpenid());
        return Result.ok(respVo);
    }

    @ApiOperation("测试")
    @GetMapping("/generateTest")
    public Result<Integer> generateTest() {
        return weChatFeign.generateTest();
    }
}
