package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginAesUtil;
import com.biz.crm.utils.LoginEncryptUtil;
import com.biz.crm.utils.VerificationUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/mdmSystemLoginController")
@Api(tags = "MDM-登录登出-系统后台")
@CrmGlobalLog
@Slf4j
public class MdmSystemLoginController {

    @Autowired
    private RedisService redisService;
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;



    @ApiOperation("登录（账号+密码）")
    @PostMapping("/login")
    public Result<MdmLoginRespVo> login(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.login(revert(reqVo)));
    }

    @ApiOperation("登录（账号+密码+图形验证码）")
    @PostMapping("/login/v2")
    public Result<MdmLoginRespVo> loginVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        VerificationUtil.checkVerification(reqVo.getUjlrwebjruzddjnu(),reqVo.getVfymoeapvkxygsef());
        return Result.ok(mdmSystemLoginService.login(revert(reqVo)));
    }

    @ApiOperation("登录（手机号+密码）")
    @PostMapping("/loginByPhone")
    public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginByPhone(revert(reqVo)));
    }

    @ApiOperation("登录（邮箱+密码）")
    @PostMapping("/loginByEmail")
    public Result<MdmLoginRespVo> loginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginByEmail(revert(reqVo)));
    }

    @ApiOperation("登录（手机号+验证码）")
    @PostMapping("/loginByPhoneVerification")
    public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginByPhoneVerification(revert(reqVo)));
    }

    @ApiOperation("登录（邮箱+验证码）")
    @PostMapping("/loginByEmailVerification")
    public Result<MdmLoginRespVo> loginByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginByEmailVerification(revert(reqVo)));
    }

    @ApiOperation("校验手机号是否存在且可用（用于登录后台）")
    @PostMapping("/checkPhoneExistAndUsable")
    public Result checkPhoneExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.checkPhoneExistAndUsable(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("校验邮箱是否存在且可用（用于登录后台）")
    @PostMapping("/checkEmailExistAndUsable")
    public Result checkEmailExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.checkEmailExistAndUsable(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送登录验证码（手机号）")
    @PostMapping("/sendVerificationForLoginByMessage")
    public Result sendVerificationForLoginByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginByMessage(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送登录验证码（邮箱）")
    @PostMapping("/sendVerificationForLoginByEmail")
    public Result sendVerificationForLoginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginByEmail(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("验证重置密码验证码并登录（手机号+验证码）")
    @PostMapping("/loginAndResetByPhoneVerification")
    public Result<MdmLoginRespVo> loginAndResetByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginAndResetByPhoneVerification(revert(reqVo)));
    }

    @ApiOperation("验证重置密码验证码并登录（邮箱+验证码）")
    @PostMapping("/loginAndResetByEmailVerification")
    public Result<MdmLoginRespVo> loginAndResetByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmSystemLoginService.loginAndResetByEmailVerification(revert(reqVo)));
    }

    @ApiOperation("发送重置密码验证码（手机号）")
    @PostMapping("/sendVerificationForLoginAndResetByMessage")
    public Result sendVerificationForLoginAndResetByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginAndResetByMessage(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送重置密码验证码（邮箱）")
    @PostMapping("/sendVerificationForLoginAndResetByEmail")
    public Result sendVerificationForLoginAndResetByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginAndResetByEmail(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("获取登录方式的控制参数")
    @PostMapping("/getLoginTypeControlConfig")
    public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
        return Result.ok(mdmSystemLoginService.getLoginTypeControlConfig());
    }

    @ApiOperation("退出登录（退出当前会话）")
    @PostMapping("/logout")
    public Result logout() {
        mdmSystemLoginService.logout();
        return Result.ok();
    }

    @ApiOperation("退出登录（退出当前会话账号在后台的全部会话）")
    @PostMapping("/logoutFromType")
    public Result logoutFromType() {
        mdmSystemLoginService.logoutFromType();
        return Result.ok();
    }

    @ApiOperation("退出登录（退出当前会话账号在所有平台的全部会话）")
    @PostMapping("/logoutAll")
    public Result logoutAll() {
        mdmSystemLoginService.logoutAll();
        return Result.ok();
    }

    /**
     * 把加密参数转换成已有参数
     *
     * @param reqVo
     * @return
     */
    private MdmLoginReqVo revert(MdmLoginEncryptReqVo reqVo) {
        ThreadLocalUtil.delObj();
        MdmLoginReqVo loginReqVo = new MdmLoginReqVo();
        if (StringUtils.isNotEmpty(reqVo.getUjlrwebjruzddjnu())) {
            loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty(reqVo.getPthxivgijazekrss())) {
            loginReqVo.setPassword(LoginAesUtil.decrypt(reqVo.getPthxivgijazekrss()));
        } else if (StringUtils.isNotEmpty(reqVo.getPazjofxkyvyoosot())) {
            loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
        } else if (StringUtils.isNotEmpty(reqVo.getPenijmgsbybkfjvr())) {
            loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        } else {

        }
        if (StringUtils.isNotEmpty(reqVo.getTwpbmjhfxodboggf())) {
            loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty(reqVo.getExzvsxwhvcvcctyk())) {
            loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty(reqVo.getVfymxygsefoeapvk())) {
            loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
        loginReqVo.setFromType(LoginFromTypeEnum.CONSOLE.getValue());
        return loginReqVo;
    }

    @GetMapping(value = "/code/{ujlrwebjruzddjnu}")
    public Result<Object> defaultKaptcha(@PathVariable("ujlrwebjruzddjnu") String ujlrwebjruzddjnu){
        Assert.hasText(ujlrwebjruzddjnu, "请先输入帐号");
        VerificationUtil.generate(ujlrwebjruzddjnu);
        return Result.ok();
    }

    /**
     * 通过token查询用户信息
     * @param ujlrwebjruzddjnu
     * @return
     */
    @GetMapping(value = "/findUserByToken/{token}")
    public Result<MdmLoginRespVo> findUserByToken(@PathVariable("token") String token){
        Assert.hasText(token, "请先输入token");
        UserUtils.setToken(token);
        MdmLoginRespVo respVo = mdmSystemLoginService.findUserByToken();
        return Result.ok(respVo);
    }
}
