package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmTerminalAppletLoginService;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginParamRespVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.weixin.OpenIdUtil;
import com.biz.crm.util.weixin.OpenIdVo;
import com.biz.crm.utils.LoginAesUtil;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName: MdmTerminalAppletLoginController
 * @Author: yangfan
 * @Description: 门店登录登出微信小程序
 * @Date: 2021/8/18 10:04
 * @Version: 1.0
 */
@RestController
@RequestMapping("/mdmTerminalAppletLoginController")
@Api(tags = "MDM-终端登录登出-TERMINAL微信小程序")
@CrmGlobalLog
@Slf4j
public class MdmTerminalAppletLoginController {

  @Autowired
  private MdmTerminalAppletLoginService mdmTerminalAppletLoginService;

  @ApiOperation("登录（账号+密码+openId）")
  @PostMapping("/login")
  public Result<MdmLoginRespVo> login(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    return Result.ok(mdmTerminalAppletLoginService.login(revert(reqVo)));
  }

  @ApiOperation("登录（手机号+密码+openId）")
  @PostMapping("/loginByPhone")
  public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    return Result.ok(mdmTerminalAppletLoginService.loginByPhone(revert(reqVo)));
  }

  @ApiOperation("登录（手机号+验证码+openId）")
  @PostMapping("/loginByPhoneVerification")
  public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    return Result.ok(mdmTerminalAppletLoginService.loginByPhoneVerification(revert(reqVo)));
  }

  @ApiOperation("发送手机号登录验证码")
  @PostMapping("/sendVerificationForLoginByMessage")
  public Result sendVerificationForLoginByMessage(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    mdmTerminalAppletLoginService.sendVerificationForLoginByMessage(revert(reqVo));
    return Result.ok();
  }

  @ApiOperation("免密登录（通过微信登录凭证）并且获得openId")
  @PostMapping("/loginByCode")
  public Result<MdmLoginRespVo> loginByCode(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
    mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
    try {
      String code = reqVo.getCxfyzzpcxaqcwmai();
      Assert.hasText(code, "缺失微信登录凭证");
      OpenIdVo openIdVo = OpenIdUtil.getSfaAppletOpenId(code);
      Assert.notNull(openIdVo, "获取openId失败");
      Assert.hasText(openIdVo.getOpenid(), "获取openId失败");
      mdmLoginRespVo.setOpenId(openIdVo.getOpenid());
      MdmAppletLoginReqVo revert = revert(reqVo);
      revert.setOpenId(openIdVo.getOpenid());
      mdmLoginRespVo = mdmTerminalAppletLoginService.loginByOpenId(revert);
    } catch (Exception e) {
      e.printStackTrace();
      log.error("免密登录（通过微信登录凭证）失败：{}", e);
      mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
    }
    return Result.ok(mdmLoginRespVo);
  }

  @ApiOperation("（不安全）免密登录（通过openId）")
  @PostMapping("/loginByOpenId")
  public Result<MdmLoginRespVo> loginByOpenId(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    MdmLoginRespVo mdmLoginRespVo = null;
    try {
      mdmLoginRespVo = mdmTerminalAppletLoginService.loginByOpenId(revert(reqVo));
      mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
    } catch (Exception e) {
      e.printStackTrace();
      log.error("免密登录（通过openId）失败：{}", e);
      mdmLoginRespVo = new MdmLoginRespVo();
      mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
    }
    return Result.ok(mdmLoginRespVo);
  }

  @ApiOperation("发送重置密码验证码（手机号）")
  @PostMapping("/sendVerificationForLoginAndResetByMessage")
  public Result sendVerificationForLoginAndResetByMessage(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    mdmTerminalAppletLoginService.sendVerificationForLoginAndResetByMessage(revert(reqVo));
    return Result.ok();
  }

  @ApiOperation("校验手机号是否存在且可用")
  @PostMapping("/checkPhoneExistAndUsable")
  public Result checkPhoneExistAndUsable(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    mdmTerminalAppletLoginService.checkPhoneExistAndUsable(revert(reqVo));
    return Result.ok();
  }

  @ApiOperation("验证重置密码验证码并登录（手机号+验证码）")
  @PostMapping("/loginAndResetByPhoneVerification")
  public Result<MdmLoginRespVo> loginAndResetByPhoneVerification(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    return Result.ok(mdmTerminalAppletLoginService.loginAndResetByPhoneVerification(revert(reqVo)));
  }

  @ApiOperation("获取登录方式的控制参数")
  @PostMapping("/getLoginTypeControlConfig")
  public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
    return Result.ok(mdmTerminalAppletLoginService.getLoginTypeControlConfig());
  }

  @ApiOperation("退出登录（退出当前会话）")
  @PostMapping("/logout")
  public Result logout() {
    mdmTerminalAppletLoginService.logout();
    return Result.ok();
  }

  @ApiOperation("退出登录（退出当前会话账号在SFA微信小程序的全部会话）")
  @PostMapping("/logoutFromType")
  public Result logoutFromType() {
    mdmTerminalAppletLoginService.logoutFromType();
    return Result.ok();
  }

  @ApiOperation("退出登录（退出当前会话账号在所有平台的全部会话）")
  @PostMapping("/logoutAll")
  public Result logoutAll() {
    mdmTerminalAppletLoginService.logoutAll();
    return Result.ok();
  }

  @ApiOperation(value = "根据微信登录凭证获取终端小程序openId", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "code", value = "微信登录凭证", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/getTerminalAppletOpenIdByCode")
  public Result<MdmAppletLoginParamRespVo> getTerminalAppletOpenIdByCode(@RequestParam(value = "code", required = true) String code) {
    OpenIdVo openIdVo = OpenIdUtil.getTerminalAppletOpenId(code);
    Assert.notNull(openIdVo, "获取openId失败");
    Assert.hasText(openIdVo.getOpenid(), "获取openId失败");
    MdmAppletLoginParamRespVo respVo = new MdmAppletLoginParamRespVo();
    respVo.setOpenId(openIdVo.getOpenid());
    return Result.ok(respVo);
  }


  /**
   * 把加密参数转换成已有参数
   *
   * @param reqVo
   * @return
   */
  private MdmAppletLoginReqVo revert(MdmAppletLoginEncryptReqVo reqVo) {
    ThreadLocalUtil.delObj();
    MdmAppletLoginReqVo loginReqVo = new MdmAppletLoginReqVo();
    if (StringUtils.isNotEmpty(reqVo.getUjlrwebjruzddjnu())) {
      loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
    }
    if (StringUtils.isNotEmpty(reqVo.getPthxivgijazekrss())) {
      loginReqVo.setPassword(LoginAesUtil.decrypt(reqVo.getPthxivgijazekrss()));
    } else if (StringUtils.isNotEmpty(reqVo.getPazjofxkyvyoosot())) {
      loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
    } else if (StringUtils.isNotEmpty(reqVo.getPenijmgsbybkfjvr())) {
      loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
    } else {

    }
    if (StringUtils.isNotEmpty(reqVo.getTwpbmjhfxodboggf())) {
      loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
    }
    if (StringUtils.isNotEmpty(reqVo.getExzvsxwhvcvcctyk())) {
      loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
    }
    if (StringUtils.isNotEmpty(reqVo.getVfymxygsefoeapvk())) {
      loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
    }
    if (StringUtils.isNotEmpty(reqVo.getOictwizfeumvvukh())) {
      loginReqVo.setOpenId(reqVo.getOictwizfeumvvukh());
    }
    if (StringUtils.isNotEmpty(reqVo.getWhspxyaumrkpgppm())) {
      loginReqVo.setHeadImgUrl(reqVo.getWhspxyaumrkpgppm());
    }
    if (StringUtils.isNotEmpty(reqVo.getWntyjilgzehqkbmy())) {
      loginReqVo.setNickName(reqVo.getWntyjilgzehqkbmy());
    }
    if (StringUtils.isNotEmpty(reqVo.getTerminalCode())) {
      loginReqVo.setTerminalCode(reqVo.getTerminalCode());
    }
    if (StringUtils.isNotEmpty(reqVo.getCustomerCode())) {
      loginReqVo.setCustomerCode(reqVo.getCustomerCode());
    }
    loginReqVo.setFromType(LoginFromTypeEnum.APPLET_TERMINAL.getValue());
    return loginReqVo;
  }


  @ApiOperation("cps终端注册时发送手机号获取验证码")
  @PostMapping("/sendTerminalVerificationByMessage")
  public Result sendTerminalVerificationByMessage(@RequestParam(value = "phoneCode") String phoneCode) {
    mdmTerminalAppletLoginService.sendTerminalVerificationByMessage(phoneCode);
    return Result.ok();
  }

  @ApiOperation("cps终端注册时验证：验证码对应的手机号码是否正确")
  @PostMapping("/VerificationPhoneByCode")
  public Result<Boolean> VerificationPhoneByCode(@RequestParam(value = "phoneCode") String phoneCode,@RequestParam(value = "verificationCode") String verificationCode) {
    mdmTerminalAppletLoginService.VerificationPhoneByCode(phoneCode,verificationCode);
    return Result.ok(true);
  }

  @ApiOperation("登录(openId+手机号+终端编码/客户编码)")
  @PostMapping("/loginByOpenIdAndPhoneAndCode")
  public Result<MdmLoginRespVo> loginByOpenIdAndPhoneAndCode(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    return Result.ok(mdmTerminalAppletLoginService.loginByOpenIdAndPhoneAndCode(revert(reqVo)));
  }

  @ApiOperation("用户切换终端")
  @PostMapping("/switchoverTerminal")
  public Result switchoverTerminal(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
    mdmTerminalAppletLoginService.switchoverTerminal(revert(reqVo));
    return Result.ok();
  }

  @ApiOperation("通过手机号重置密码")
  @PostMapping("/resetPasswordByPhone")
  public Result resetPasswordByPhone(@RequestParam(value = "phoneCode") String phoneCode, @RequestParam(value = "password") String password) {
    mdmTerminalAppletLoginService.resetPasswordByPhone(phoneCode, password);
    MdmAppletLoginEncryptReqVo reqVo = new MdmAppletLoginEncryptReqVo();
    reqVo.setTwpbmjhfxodboggf(phoneCode);
    reqVo.setPenijmgsbybkfjvr(password);
    return Result.ok(mdmTerminalAppletLoginService.loginByPhone(revert(reqVo)));
  }

  @ApiOperation("通过手机号查询终端详细信息")
  @PostMapping("/getTerminalByPhone")
  public Result<List<MdmTerminalVo>> getTerminalByPhone(@RequestParam(value = "phoneCode") String phoneCode){
    return Result.ok(mdmTerminalAppletLoginService.getTerminalByPhone(phoneCode));
  }
}
