package com.biz.crm.login.service;

import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;

/**
 * @author zxw
 */
public interface MdmDmsAppLoginService {

    /**
     * 账号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo login(MdmLoginReqVo reqVo);

    /**
     * 手机号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo);

    /**
     * 邮箱密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo);

    /**
     * 手机号+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo);

    /**
     * 发送手机号登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo);

    /**
     * 发送邮箱登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo);

    /**
     * 校验手机号是否可用
     *
     * @param reqVo
     */
    void checkPhoneExistAndUsable(MdmLoginReqVo reqVo);

    /**
     * 校验邮箱是否可用
     *
     * @param reqVo
     */
    void checkEmailExistAndUsable(MdmLoginReqVo reqVo);

    /**
     * 发送手机号登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo);

    /**
     * 发送邮箱登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo);

    /**
     * 手机号+验证码登录并需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录并且需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo);

    /**
     * 获取登录方式控制
     *
     * @return
     */
    MdmLoginTypeControlVo getLoginTypeControlConfig();
}
