package com.biz.crm.login.service;

import com.biz.crm.utils.LoginHelpUtil;

import java.util.Set;

public interface MdmLoginHelpService {

    /**
     * 判断账号是否被锁定（锁定会直接抛异常）
     *
     * @param account     账号关键值
     * @param accountType 账号类型
     */
    void checkLock(String account, LoginHelpUtil.AccountType accountType);

    /**
     * 添加密码错误次数并抛异常
     *
     * @param userName 登录账号（必填）
     * @param phone    手机号（如果登录账号对应用户有手机号则必填）
     * @param email    邮箱（如果登录账号对应用户有邮箱则必填）
     */
    void addError(String userName, String phone, String email);

    /**
     * 校验用户是否可用
     *
     * @param enableStatus
     * @param startTime
     * @param endTime
     */
    void checkUserLogin(String enableStatus, String startTime, String endTime);

    /**
     * 校验用户类型与登录入口是否匹配
     *
     * @param userType
     * @param fromType
     */
    void checkUserType(String userType, String fromType);

    /**
     * 获取账号锁定时间（分钟）
     *
     * @param account
     * @param accountType
     * @return
     */
    long getLockMinutes(String account, LoginHelpUtil.AccountType accountType);

    /**
     * 解锁
     *
     * @param userName 登录账号（必填）
     * @param phone    手机号（如果登录账号对应用户有手机号则必填）
     * @param email    邮箱（如果登录账号对应用户有邮箱则必填）
     */
    void unlock(String userName, String phone, String email);

    /**
     * 获取用户最大锁定时长（分钟）
     *
     * @return
     */
    long getMaxLockMinutes();

    /**
     * 生成登录验证码并且缓存和手机号码、用户的对应关系
     *
     * @param fromType 登录入口
     * @param userName 登录账号
     * @param account  手机号或者邮箱
     * @return
     */
    String saveLoginVerificationCodeRelUser(String fromType, String userName, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType);

    /**
     * 发送验证码
     *
     * @param fromType             登录入口
     * @param verificationCode     验证码
     * @param account              账号关键值
     * @param accountType          账号类型
     * @param verificationCodeType 验证码用途
     */
    void sendVerificationCode(String fromType, String verificationCode, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType);

    /**
     * 校验用户是否被锁定，返回锁定的用户名
     *
     * @param userNameSet 用户名集合
     * @return
     */
    Set<String> checkAndGetLockUserName(Set<String> userNameSet);

    /**
     * 校验验证码
     *
     * @param fromType             登录入口
     * @param verificationCode     验证码
     * @param account              账号关键值
     * @param accountType          账号类型
     * @param verificationCodeType 验证码用途
     * @return
     */
    String checkVerificationCode(String fromType, String verificationCode, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType);


    /**
     * 生成验证码信息
     */
    String generateVerificationCode();

}
