package com.biz.crm.login.service;

import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;

/**
 * @author zxw
 */
public interface MdmSfaAppletLoginService {

    /**
     * 账号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo login(MdmAppletLoginReqVo reqVo);

    /**
     * 手机号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo);

    /**
     * 邮箱密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmail(MdmAppletLoginReqVo reqVo);

    /**
     * 手机号+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmailVerification(MdmAppletLoginReqVo reqVo);

    /**
     * 发送手机号登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo);

    /**
     * 发送邮箱登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByEmail(MdmAppletLoginReqVo reqVo);

    /**
     * 校验手机号是否可用
     *
     * @param reqVo
     */
    void checkPhoneExistAndUsable(MdmAppletLoginReqVo reqVo);

    /**
     * 校验邮箱是否可用
     *
     * @param reqVo
     */
    void checkEmailExistAndUsable(MdmAppletLoginReqVo reqVo);

    /**
     * 发送手机号登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByMessage(MdmAppletLoginReqVo reqVo);

    /**
     * 发送邮箱登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByEmail(MdmAppletLoginReqVo reqVo);

    /**
     * 手机号+验证码登录并需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByPhoneVerification(MdmAppletLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录并且需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByEmailVerification(MdmAppletLoginReqVo reqVo);

    /**
     * 通过openId登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo);

    /**
     * 获取登录方式控制
     *
     * @return
     */
    MdmLoginTypeControlVo getLoginTypeControlConfig();

    /**
     * 退出当前会话
     */
    void logout();

    /**
     * 退出登录（退出当前会话账号在SFA微信小程序的全部会话）
     */
    void logoutFromType();

    /**
     * 退出登录（退出当前会话账号在所有平台的全部会话）
     */
    void logoutAll();
}
