package com.biz.crm.login.service.impl;

import com.biz.crm.login.service.MdmSfaAppLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 系统登录业务层
 *
 * @author zxw
 * @date 2020-11-19 15:48
 **/
@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmSfaAppLoginServiceExpandImpl")
public class MdmSfaAppLoginServiceImpl implements MdmSfaAppLoginService {

    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.login(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginByPhone(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginByEmail(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginByPhoneVerification(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginByEmailVerification(reqVo);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginByMessage(reqVo);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginByEmail(reqVo);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.checkPhoneExistAndUsable(reqVo);
    }

    @Override
    public void checkEmailExistAndUsable(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.checkEmailExistAndUsable(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginAndResetByMessage(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo) {
        mdmSystemLoginService.sendVerificationForLoginAndResetByEmail(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginAndResetByPhoneVerification(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo) {
        return mdmSystemLoginService.loginAndResetByEmailVerification(reqVo);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        return mdmSystemLoginService.getLoginTypeControlConfig();
    }
}
