package com.biz.crm.material.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Slf4j
@RestController
@RequestMapping("/mdmMaterialController")
@Api(tags = "MDM-物料管理")
@CrmGlobalLog
public class MdmMaterialController {

    @Autowired
    private MdmMaterialService mdmMaterialService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmMaterialRespVo>> pageList(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        PageResult<MdmMaterialRespVo> result = mdmMaterialService.findList(mdmMaterialReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "materialCode", value = "物料编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmDictMethod
    public Result<MdmMaterialRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "materialCode", required = false) String materialCode) {
        MdmMaterialRespVo respVo = mdmMaterialService.detail(id, materialCode);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        mdmMaterialService.save(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        mdmMaterialService.update(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmMaterialService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmMaterialService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmMaterialService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "物料下拉框")
    @PostMapping("/materialSelect")
    public Result<List<MdmMaterialSelectRespVo>> materialSelect(@RequestBody MdmMaterialSelectReqVo reqVo) {
        return Result.ok(mdmMaterialService.materialSelect(reqVo));
    }

    @ApiOperation(value = "物料下拉框（只查询启用的）")
    @PostMapping("/materialSelectEnable")
    public Result<List<MdmMaterialSelectRespVo>> materialSelectEnable(@RequestBody MdmMaterialSelectReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return Result.ok(mdmMaterialService.materialSelect(reqVo));
    }

    @ApiOperation(value = "查询物料")
    @PostMapping("/findCurrentAndSubMaterialList")
    public Result<List<MdmMaterialPriceRespVo>> findCurrentAndSubMaterialList(@RequestBody MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
        List<MdmMaterialPriceRespVo> result = mdmMaterialService.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        return Result.ok(result);
    }


    @ApiOperation(value = "查询分页列表(提供给cps模块)")
    @PostMapping("/pageCpsList")
    @CrmDictMethod
    public Result<PageResult<MdmMaterialRespVo>> pageCpsList(@RequestBody MaterialMdmPaginationDto paginationDto) {
        PageResult<MdmMaterialRespVo> result = mdmMaterialService.findCpsList(paginationDto);
        return Result.ok(result);
    }
}
