package com.biz.crm.material.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.material.service.MdmMaterialGroupService;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: MdmMaterialGroupController
 * @Author: yangfan
 * @Description: 物料组管理controller
 * @Date: 2021/8/19 11:13
 * @Version: 1.0
 */

@Slf4j
@RestController
@RequestMapping("/mdmMaterialGroupController")
@Api(tags = "MDM-物料组管理")
@CrmGlobalLog
public class MdmMaterialGroupController {

  @Autowired
  private MdmMaterialGroupService mdmMaterialGroupService;

  @ApiOperation(value = "查询分页列表")
  @PostMapping("/pageList")
  @CrmDictMethod
  public Result<PageResult<MdmMaterialGroupRespVo>> pageList(@RequestBody MdmMaterialGroupReqVo groupReqVo) {
    PageResult<MdmMaterialGroupRespVo> result = mdmMaterialGroupService.findList(groupReqVo);
    return Result.ok(result);
  }

  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "materialGroupCode", value = "物料组编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  @CrmDictMethod
  public Result<MdmMaterialGroupRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "materialGroupCode", required = false) String materialGroupCode) {
    MdmMaterialGroupRespVo respVo = mdmMaterialGroupService.detail(id, materialGroupCode);
    return Result.ok(respVo);
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result save(@RequestBody MdmMaterialGroupReqVo mdmMaterialGroupReqVo) {
    mdmMaterialGroupService.save(mdmMaterialGroupReqVo);
    return Result.ok();
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody MdmMaterialGroupReqVo mdmMaterialGroupReqVo) {
    mdmMaterialGroupService.update(mdmMaterialGroupReqVo);
    return Result.ok();
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    mdmMaterialGroupService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    mdmMaterialGroupService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    mdmMaterialGroupService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  @ApiOperation(value = "提供给cps的物料组查询分页列表")
  @PostMapping("/pageGroupCpsList")
  @CrmDictMethod
  public Result<PageResult<MdmMaterialGroupRespVo>> pageGroupCpsList(@RequestBody MdmMaterialGroupReqVo groupReqVo) {
    PageResult<MdmMaterialGroupRespVo> result = mdmMaterialGroupService.pageGroupCpsList(groupReqVo);
    return Result.ok(result);
  }
}
