package com.biz.crm.material.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.material.model.MdmMaterialGroupEntity;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @ClassName: MdmMaterialGroupMapper
 * @Author: yangfan
 * @Description: 物料组mapper
 * @Date: 2021/8/19 11:40
 * @Version: 1.0
 */
public interface MdmMaterialGroupMapper extends BaseMapper<MdmMaterialGroupEntity> {

  /**
   *分页查询物料组信息
   * @param page
   * @param groupReqVo
   * @return
   */
  List<MdmMaterialGroupRespVo> findList(Page<MdmMaterialGroupRespVo> page, @Param("vo") MdmMaterialGroupReqVo groupReqVo);

  /**
   * 提供给cps分页查询物料组信息
   * @param page
   * @param groupReqVo
   * @return
   */
  List<MdmMaterialGroupRespVo> findCpsList(Page<MdmMaterialGroupRespVo> page,@Param("vo") MdmMaterialGroupReqVo groupReqVo);
}
