package com.biz.crm.material.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @author zxw
 * @date 2020-12-28 12:16
 **/
public class MdmMaterialProvider {

    public String findListProvider(Map<String,Object> map) {
        MdmMaterialReqVo vo = (MdmMaterialReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {
            {
                SELECT("a.*,b.product_level_name");
                FROM("mdm_material a");
                LEFT_OUTER_JOIN("mdm_product_level b on a.product_level_code=b.product_level_code");
                if (StringUtils.isNotEmpty(vo.getEnableStatus())) {
                    WHERE("a.enable_status = #{vo.enableStatus}");
                }
                if (StringUtils.isNotEmpty(vo.getSaleCompany())) {
                    WHERE("a.sale_company = #{vo.saleCompany}");
                }
                if (StringUtils.isNotEmpty(vo.getMaterialType())) {
                    WHERE("a.material_type = #{vo.materialType}");
                }
                if (StringUtils.isNotEmpty(vo.getSaleUnit())) {
                    WHERE("a.sale_unit = #{vo.saleUnit}");
                }
                if (StringUtils.isNotEmpty(vo.getBaseUnit())) {
                    WHERE("a.base_unit = #{vo.baseUnit}");
                }
                if (StringUtils.isNotEmpty(vo.getMaterialCode())) {
                    WHERE("a.material_code like " +ProviderUtil.bindPercent(vo.getMaterialCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty(vo.getMaterialName())) {
                    WHERE("a.material_name like " +ProviderUtil.bindPercent(vo.getMaterialName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty(vo.getAiCode())) {
                    WHERE("a.ai_code like " + ProviderUtil.bindPercent(vo.getAiCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty(vo.getRuleCode())) {
                    WHERE("a.rule_code like "+ ProviderUtil.bindPercent(vo.getRuleCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                    WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }

}
