package com.biz.crm.material.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.*;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.mapper.MdmMaterialMediaMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.model.MdmMaterialMediaEntity;
import com.biz.crm.material.service.MdmMaterialMediaService;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.*;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelVo;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import joptsimple.internal.Strings;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 接口实现
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmMaterialServiceExpandImpl")
public class MdmMaterialServiceImpl<M extends BaseMapper<T>, T> extends
    ServiceImpl<MdmMaterialMapper, MdmMaterialEntity> implements MdmMaterialService {

  @Resource
  private MdmMaterialMapper mdmMaterialMapper;
  @Resource
  private MdmProductLevelService mdmProductLevelService;
  @Resource
  private MdmProductMaterialService mdmProductMaterialService;
  @Resource
  private MdmProductService mdmProductService;
  @Autowired
  private CrmLogSendUtil crmLogSendUtil;
  @Resource
  private MdmMaterialMediaMapper mdmMaterialMediaMapper;
  @Resource
  private MdmMaterialMediaService mdmMaterialMediaService;


  private final String UNIT_CONVERSION_REGEX = "^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$";
  private final String COST_PRICE_REGEX = "(^[1-9](\\d+)?(\\.\\d{1,2})?$)|(^\\d\\.\\d{1,2}$)";

  @Override
  public PageResult<MdmMaterialRespVo> findList(MdmMaterialReqVo mdmMaterialReqVo) {
    Page<MdmMaterialRespVo> page = PageUtil
        .buildPage(mdmMaterialReqVo.getPageNum(), mdmMaterialReqVo.getPageSize());
    if (StringUtils.isNotEmpty(mdmMaterialReqVo.getCode())) {
      MdmProductLevelRespVo productLevel = mdmProductLevelService
          .detail(null, mdmMaterialReqVo.getCode());
      mdmMaterialReqVo.setRuleCode(productLevel.getRuleCode());
    }
    List<MdmMaterialRespVo> list = mdmMaterialMapper.findList(page, mdmMaterialReqVo);
    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
      final Map<String, String> map = DictUtil.dictMap(DictConstant.SALE_COMPANY);
      List<String> ids = list.stream().map(MdmMaterialRespVo::getId)
          .collect(Collectors.toList());
      //查询主图片
      List<MdmMaterialMediaRespVo> mediaPicList = mdmMaterialMediaService.findMediaListByIds(ids);
      Map<String, List<MdmMaterialMediaRespVo>> relMap = new HashMap<>();
      if (CollectionUtil.listNotEmptyNotSizeZero(mediaPicList)) {
        relMap.putAll(mediaPicList.stream().filter(item -> Objects.nonNull(item.getMaterialCode()))
            .collect(Collectors.groupingBy(MdmMaterialMediaRespVo::getMaterialCode)));
      }
      list.forEach(item -> {
        String saleCompanyName = "";
        String saleCompany = item.getSaleCompany();
        if (StringUtils.isNotEmpty(saleCompany)) {
          List<String> saleCompanyNameList = new ArrayList<>();
          for (String saleCompanyCode : saleCompany.split(",")) {
            if (map.containsKey(saleCompanyCode)) {
              saleCompanyNameList.add(map.get(saleCompanyCode));
            }
          }
          if (CollectionUtil.listNotEmptyNotSizeZero(saleCompanyNameList)) {
            saleCompanyName = String.join(",", saleCompanyNameList);
          }
        }
        List<MdmMaterialMediaRespVo> mdmMaterialMediaRespVos = relMap
            .get(item.getMaterialCode());
        if (CollectionUtil.listNotEmptyNotSizeZero(mdmMaterialMediaRespVos)) {
          item.setImgUrl(mdmMaterialMediaRespVos.get(0).getUrlAddress());
        }
        item.setSaleCompanyName(saleCompanyName);
      });
    }
    //

    return PageResult.<MdmMaterialRespVo>builder()
        .data(list)
        .count(page.getTotal())
        .build();
  }

  @Override
  public MdmMaterialRespVo detail(String id, String materialCode) {
    if (StringUtils.isNotEmpty(id) || StringUtils.isNotEmpty(materialCode)) {
      MdmMaterialEntity one = this.lambdaQuery()
          .eq(StringUtils.isNotEmpty(id), MdmMaterialEntity::getId, id)
          .eq(StringUtils.isNotEmpty(materialCode), MdmMaterialEntity::getMaterialCode,
              materialCode)
          .one();
      if (one != null) {
        MdmMaterialRespVo respVo = CrmBeanUtil.copy(one, MdmMaterialRespVo.class);
        if (StringUtils.isNotEmpty(one.getSaleCompany())) {
          respVo.setSaleCompanyList(Arrays.asList(one.getSaleCompany().split(",")));
        }
        MdmProductLevelRespVo productLevel = mdmProductLevelService
            .detail(null, one.getProductLevelCode());
        if (productLevel != null) {
          respVo.setProductLevelName(productLevel.getProductLevelName());
        }
        List<MdmMaterialMediaRespVo> mdmMaterialMediaRespVos = mdmMaterialMediaService
            .findMediaListByCondition(id, materialCode);
        respVo.setPicList(mdmMaterialMediaRespVos);
        return respVo;
      }
    }
    return null;
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void save(MdmMaterialReqVo mdmMaterialReqVo) {
    Assert.hasText(mdmMaterialReqVo.getMaterialName(), "物料名称不能为空");
    if (StringUtils.isNotEmpty(mdmMaterialReqVo.getCostPrice())) {
      Assert.isTrue(mdmMaterialReqVo.getCostPrice().matches(COST_PRICE_REGEX),
          "成本价格式不正确：请输入正数，保留两位小数");
    }
    if (mdmMaterialReqVo.getBoxUnitConversion() != null) {
      String boxConversion = mdmMaterialReqVo.getBoxUnitConversion().toString();
      Assert.isTrue(boxConversion.matches(COST_PRICE_REGEX), "盒码单位转算系数不正确：请输入正数，保留两位小数");
    }

    if (mdmMaterialReqVo.getCaseUnitConversion() != null) {
      String caseConversion = mdmMaterialReqVo.getCaseUnitConversion().toString();
      Assert.isTrue(caseConversion.matches(COST_PRICE_REGEX), "箱码单位转算系数不正确：请输入正数，保留两位小数");
    }

    if (StringUtils.isEmpty(mdmMaterialReqVo.getMaterialCode())) {
      mdmMaterialReqVo
          .setMaterialCode(CodeUtil.generateCode(CodeRuleEnum.MDM_MATERIAL_CODE.getCode()));
    } else {
      MdmMaterialRespVo query = this.detail(null, mdmMaterialReqVo.getMaterialCode());
      Assert.isNull(query, "物料编码已存在:" + mdmMaterialReqVo.getMaterialCode());
    }
//        String unitConversion = mdmMaterialReqVo.getUnitConversion();
//        Assert.isTrue(!StringUtils.isEmpty(unitConversion) && unitConversion.matches(UNIT_CONVERSION_REGEX), "单位换算系数必须是正数");
    if (CollectionUtil.listNotEmptyNotSizeZero(mdmMaterialReqVo.getSaleCompanyList())) {
      mdmMaterialReqVo.setSaleCompany(Strings.join(mdmMaterialReqVo.getSaleCompanyList(), ","));
    }

    List<MdmMaterialMediaReqVo> picList = mdmMaterialReqVo.getPicList();
    List<MdmMaterialMediaEntity> mdmMaterialEntityList = CrmBeanUtil
        .copyList(picList, MdmMaterialMediaEntity.class);

    // 自动生成产品信息 配置全局变量开关
    if (YesNoEnum.yesNoEnum.Y.getValue()
        .equals(ParamUtil.getParameterValue(ParameterParam.MATERIAL_CREATE_PRODUCT_AUTOMATIC))) {
      this.saveProductInfoAtomic(mdmMaterialReqVo);
    }

    MdmMaterialEntity entity = CrmBeanUtil.copy(mdmMaterialReqVo, MdmMaterialEntity.class);
    this.save(entity);
    // 保存照片信息
    this.saveMaterialMedias(mdmMaterialEntityList, Boolean.TRUE, entity);
    Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
    if (menuObject != null) {
      crmLogSendUtil.sendForAdd(menuObject.toString(), entity.getId(), entity.getMaterialCode(),
          CrmBeanUtil.copy(entity, MdmMaterialReqVo.class));
    }
  }


  @Override
  @Transactional(rollbackFor = Exception.class)
  public void update(MdmMaterialReqVo mdmMaterialReqVo) {
    Assert.hasText(mdmMaterialReqVo.getId(), "id不能为空");
    Assert.hasText(mdmMaterialReqVo.getMaterialName(), "物料名称不能为空");
    if (StringUtils.isNotEmpty(mdmMaterialReqVo.getCostPrice())) {
      Assert.isTrue(mdmMaterialReqVo.getCostPrice().matches(COST_PRICE_REGEX),
          "成本价格式不正确：请输入正数，保留两位小数");
    }
    if (mdmMaterialReqVo.getBoxUnitConversion() != null) {
      String boxConversion = mdmMaterialReqVo.getBoxUnitConversion().toString();
      Assert.isTrue(boxConversion.matches(COST_PRICE_REGEX), "盒码单位转算系数不正确：请输入正数，保留两位小数");
    }

    if (mdmMaterialReqVo.getCaseUnitConversion() != null) {
      String caseConversion = mdmMaterialReqVo.getCaseUnitConversion().toString();
      Assert.isTrue(caseConversion.matches(COST_PRICE_REGEX), "箱码单位转算系数不正确：请输入正数，保留两位小数");
    }
//        String unitConversion = mdmMaterialReqVo.getUnitConversion();
//        Assert.isTrue(!StringUtils.isEmpty(unitConversion) && unitConversion.matches(UNIT_CONVERSION_REGEX), "单位换算系数必须是正数");
    if (CollectionUtil.listNotEmptyNotSizeZero(mdmMaterialReqVo.getSaleCompanyList())) {
      mdmMaterialReqVo.setSaleCompany(Strings.join(mdmMaterialReqVo.getSaleCompanyList(), ","));
    } else {
      mdmMaterialReqVo.setSaleCompany(Strings.EMPTY);
    }
    MdmMaterialEntity entity = this.getById(mdmMaterialReqVo.getId());
    Assert.notNull(entity, "无效的id");
    MdmMaterialReqVo oldObject = CrmBeanUtil.copy(entity, MdmMaterialReqVo.class);
    CrmBeanUtil.copyProperties(mdmMaterialReqVo, entity);
    List<MdmMaterialMediaReqVo> picList = mdmMaterialReqVo.getPicList();
    List<MdmMaterialMediaEntity> mdmMaterialEntityList = CrmBeanUtil
        .copyList(picList, MdmMaterialMediaEntity.class);
    this.updateById(entity);
    // 保存照片信息
    this.saveMaterialMedias(mdmMaterialEntityList, Boolean.FALSE, entity);
    Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
    if (menuObject != null) {
      MdmMaterialReqVo newObject = CrmBeanUtil.copy(entity, MdmMaterialReqVo.class);
      crmLogSendUtil.sendForUpdate(menuObject.toString(),
          entity.getId(), entity.getMaterialCode(), oldObject, newObject);
    }
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteBatch(List<String> ids) {
    ValidateUtils.validate(ids, "ids不能为空");
    List<String> materialCodeList = new ArrayList<>();
    Object menuObject = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
    for (String id :
        ids) {
      Assert.hasText(id, "不能传空值");
      MdmMaterialEntity material = this.getById(id);
      Assert.notNull(material, "物料不存在");
      materialCodeList.add(material.getMaterialCode());
      if (menuObject != null) {
        crmLogSendUtil.sendForDel(menuObject.toString(),
            id, material.getMaterialCode(), CrmBeanUtil.copy(material, MdmMaterialReqVo.class));
      }
    }
    this.removeByIds(ids);

    //删除物料关联的商品（此操作极度残暴，请谨慎使用）

    //查询物料关联的商品物料数据
    List<MdmProductMaterialEntity> productMaterialList = mdmProductMaterialService.lambdaQuery()
        .in(MdmProductMaterialEntity::getMaterialCode, materialCodeList)
        .list();
    //查询商品物料关联的商品
    if (CollectionUtil.listNotEmptyNotSizeZero(productMaterialList)) {
      List<String> productCodeList = productMaterialList.stream()
          .map(MdmProductMaterialEntity::getProductCode).collect(Collectors.toList());
      List<MdmProductEntity> productEntityList = mdmProductService.lambdaQuery()
          .in(MdmProductEntity::getProductCode, productCodeList)
          .select(MdmProductEntity::getId)
          .list();
      //删除商品及商品的所有关联主数据信息
      if (CollectionUtil.listNotEmptyNotSizeZero(productEntityList)) {
        List<String> productIdList = productEntityList.stream().map(MdmProductEntity::getId)
            .collect(Collectors.toList());
        mdmProductService.deleteBatch(productIdList);
      }
    }

  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void enableBatch(List<String> ids) {
    Assert.notEmpty(ids, "ids不能为空");
    this.lambdaUpdate()
        .in(MdmMaterialEntity::getId, ids)
        .set(MdmMaterialEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
        .update();
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void disableBatch(List<String> ids) {
    Assert.notEmpty(ids, "ids不能为空");
    this.lambdaUpdate()
        .in(MdmMaterialEntity::getId, ids)
        .set(MdmMaterialEntity::getEnableStatus, CrmEnableStatusEnum.DISABLE.getCode())
        .update();
  }

  @Override
  public List<MdmMaterialSelectRespVo> materialSelect(MdmMaterialSelectReqVo reqVo) {
    Integer pageSize = reqVo.getPageSize();
    if (pageSize == null || pageSize == 0) {
      pageSize = Integer
          .valueOf(ParamUtil.getParameterValue(ParameterParam.SELECT_BOX_OPTION_SIZE));
    }
    List<MdmMaterialSelectRespVo> list = new ArrayList<>();
    Set<String> codeList = new HashSet<>(16);
    if (StringUtils.isNotEmpty(reqVo.getSelectedCode())) {
      codeList.add(reqVo.getSelectedCode());
    }
    if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSelectedCodeList())) {
      codeList.addAll(reqVo.getSelectedCodeList());
    }
    if (!codeList.isEmpty()) {
      reqVo.setSelectedCodeList(new ArrayList<>(codeList));
    }
    if (pageSize > 0) {
      list.addAll(
          mdmMaterialMapper.materialSelectList(new Page<>(1L, pageSize, false), reqVo, null, null));
    }
    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
      final Map<String, String> map = DictUtil.dictMap(DictConstant.SALE_COMPANY);
      list.forEach(item -> {
        String saleCompanyName = "";
        String saleCompany = item.getSaleCompany();
        if (StringUtils.isNotEmpty(saleCompany)) {
          List<String> saleCompanyNameList = new ArrayList<>();
          List<String> saleCompanyList = new ArrayList<>();
          for (String saleCompanyCode :
              saleCompany.split(",")) {
            if (map.containsKey(saleCompanyCode)) {
              saleCompanyNameList.add(map.get(saleCompanyCode));
              saleCompanyList.add(saleCompanyCode);
            }
          }
          if (CollectionUtil.listNotEmptyNotSizeZero(saleCompanyNameList)) {
            saleCompanyName = String.join(",", saleCompanyNameList);
            item.setSaleCompanyList(saleCompanyList);
          }
        }
        item.setSaleCompanyName(saleCompanyName);
      });
    }
    return list;
  }

  @Override
  public List<MdmMaterialPriceRespVo> findCurrentAndSubMaterialList(
      MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
    Map<String, String> materialBaseUnit = DictUtil.dictMap(DictConstant.MATERIAL_BASE_UNIT);
    Map<String, String> materialSaleUnit = DictUtil.dictMap(DictConstant.MATERIAL_SALE_UNIT);
    Integer pageNum = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageNum()).orElse(1);
    Integer pageSize = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageSize()).orElse(1000);
    Page<MdmMaterialRespVo> page = new Page<>(pageNum, pageSize);
    List<MdmMaterialRespVo> mdmMaterialRespVos = mdmMaterialMapper
        .pageCondition(page, mdmMaterialOrgSearchReqVo);
    if (CollectionUtils.isEmpty(mdmMaterialRespVos)) {
      return new ArrayList<>();
    }
    return mdmMaterialRespVos.stream().map(x -> {
      MdmMaterialPriceRespVo mdmMaterialPriceRespVo = CrmBeanUtil
          .copy(x, MdmMaterialPriceRespVo.class);
      MdmMaterialUnitRespVo baseUnitRespVo = new MdmMaterialUnitRespVo();
      String baseUnit = x.getBaseUnit();
      baseUnitRespVo.setUnit(baseUnit);
      baseUnitRespVo
          .setUnitName(StringUtils.isEmpty(baseUnit) ? baseUnit : materialBaseUnit.get(baseUnit));
      String costPrice = x.getCostPrice();
      baseUnitRespVo.setCostPrice(costPrice);

      MdmMaterialUnitRespVo saleUnitRespVo = new MdmMaterialUnitRespVo();
      String saleUnit = x.getSaleUnit();
      saleUnitRespVo.setUnit(saleUnit);
      saleUnitRespVo
          .setUnitName(StringUtils.isEmpty(saleUnit) ? saleUnit : materialSaleUnit.get(saleUnit));
      String unitConversion = x.getUnitConversion();
      if (!StringUtils.isEmpty(costPrice) && !StringUtils.isEmpty(unitConversion)) {
        saleUnitRespVo.setCostPrice(
            new BigDecimal(costPrice).multiply(new BigDecimal(unitConversion)).toString());
      }
      mdmMaterialPriceRespVo
          .setMdmMaterialUnitRespVos(Arrays.asList(baseUnitRespVo, saleUnitRespVo));
      return mdmMaterialPriceRespVo;
    }).collect(Collectors.toList());
  }

  @Override
  public List<MdmMaterialRespVo> findMaterialByMaterialGroupCode(String groupCode) {
    AssertUtils.isNotEmpty(groupCode, "物料组编码不能为空");
    return mdmMaterialMapper.findMaterialByMaterialGroupCode(groupCode);
  }

  @Override
  public PageResult<MdmMaterialRespVo> findCpsList(MaterialMdmPaginationDto mdmMaterialReqVo) {
    Page<MdmMaterialRespVo> page = PageUtil
        .buildPage(mdmMaterialReqVo.getPageNum(), mdmMaterialReqVo.getPageSize());
    List<MdmMaterialRespVo> list = mdmMaterialMapper.findCpsList(page, mdmMaterialReqVo);
    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
      final Map<String, String> map = DictUtil.dictMap(DictConstant.SALE_COMPANY);
      list.forEach(item -> {
        String saleCompanyName = "";
        String saleCompany = item.getSaleCompany();
        if (StringUtils.isNotEmpty(saleCompany)) {
          List<String> saleCompanyNameList = new ArrayList<>();
          for (String saleCompanyCode :
              saleCompany.split(",")) {
            if (map.containsKey(saleCompanyCode)) {
              saleCompanyNameList.add(map.get(saleCompanyCode));
            }
          }
          if (CollectionUtil.listNotEmptyNotSizeZero(saleCompanyNameList)) {
            saleCompanyName = String.join(",", saleCompanyNameList);
          }
        }
        item.setSaleCompanyName(saleCompanyName);

        // 查询所有产品层级信息
        List<MdmProductLevelVo> productLevelList = mdmProductLevelService
            .getParentCpsList(null, item.getProductLevelCode());
        item.setProductLevels(productLevelList);

        // 查询照片信息
        List<MdmMaterialMediaRespVo> mediaPicList = mdmMaterialMediaService
            .findMediaListByCondition(item.getId(), item.getMaterialCode());
        item.setPicList(mediaPicList);
      });
    }
    return PageResult.<MdmMaterialRespVo>builder()
        .data(list)
        .count(page.getTotal())
        .build();
  }

  /**
   * 保存物料图片信息
   *
   * @param mediaEntities
   */
  private void saveMaterialMedias(List<MdmMaterialMediaEntity> mediaEntities, Boolean isSave,
      MdmMaterialEntity mdmMaterialEntity) {
    if (isSave) {
      //新增
      if (CollectionUtils.isNotEmpty(mediaEntities)) {
        mediaEntities.forEach(o -> {
          o.setMaterialId(mdmMaterialEntity.getId());
          o.setMaterialCode(mdmMaterialEntity.getMaterialCode());
          mdmMaterialMediaMapper.insert(o);
        });
      }
    } else {
      //修改
      if (CollectionUtils.isNotEmpty(mediaEntities)) {
        mediaEntities.forEach(o -> {
          o.setMaterialId(mdmMaterialEntity.getId());
          o.setMaterialCode(mdmMaterialEntity.getMaterialCode());
        });
      }
      List<String> ids = mediaEntities.stream().filter(O -> StringUtils.isNotEmpty(O.getId()))
          .map(MdmMaterialMediaEntity::getId).collect(Collectors.toList());
      //如果ids不为空,先将除ids之外的图片,视频删除
      LambdaQueryWrapper<MdmMaterialMediaEntity> lambdaQuery = Wrappers
          .lambdaQuery(MdmMaterialMediaEntity.class)
          .eq(MdmMaterialMediaEntity::getMaterialCode, mdmMaterialEntity.getMaterialCode())
          .notIn(CollectionUtils.isNotEmpty(ids), MdmMaterialMediaEntity::getId, ids);
      mdmMaterialMediaMapper.delete(lambdaQuery);
      if (CollectionUtil.listNotEmptyNotSizeZero(mediaEntities)) {
        mdmMaterialMediaService.saveOrUpdateBatch(mediaEntities);
      }
    }
  }

  /**
   * 自动生成产品信息
   *
   * @param mdmMaterialReqVo
   */
  private void saveProductInfoAtomic(MdmMaterialReqVo mdmMaterialReqVo) {
    MdmProductReqVo mdmProductReqVo = new MdmProductReqVo();
    mdmProductReqVo.setProductName(mdmMaterialReqVo.getMaterialName());
    mdmProductReqVo.setProductLevelCode(mdmMaterialReqVo.getProductLevelCode());
    mdmProductReqVo.setProductLevelName(mdmMaterialReqVo.getProductLevelName());
    mdmProductReqVo.setProductType(ProductTypeEnum.STANDARD.getCode());
    mdmProductReqVo.setIsShelf(IsShelfEnum.DOWN.getCode());
    mdmProductReqVo.setBeginDate(DateUtil.date2Str(new Date(), DateUtil.datetimeFormat));
    mdmProductReqVo.setEndDate("2099-01-01 00:00:00");
    mdmProductReqVo.setBaseUnit(mdmMaterialReqVo.getBaseUnit());
    mdmProductReqVo.setSaleUnit(mdmMaterialReqVo.getSaleUnit());
    mdmProductReqVo.setSpec(mdmMaterialReqVo.getSpecification());

    // 组装物料信息
    List<MdmProductMaterialReqVo> materialList = Lists.newArrayList();
    MdmProductMaterialReqVo mdmProductMaterialReqVo = new MdmProductMaterialReqVo();
    mdmProductMaterialReqVo.setMaterialCode(mdmMaterialReqVo.getMaterialCode());
    mdmProductMaterialReqVo.setMaterialName(mdmMaterialReqVo.getMaterialName());
    mdmProductMaterialReqVo.setCount(1);
    materialList.add(mdmProductMaterialReqVo);
    mdmProductReqVo.setMaterialList(materialList);

    // 组装图片信息
    List<MdmMaterialMediaReqVo> picList = mdmMaterialReqVo.getPicList();
    if (CollectionUtils.isNotEmpty(picList)) {
      List<MdmProductMediaRespVo> mdmProductMediaRespVos = CrmBeanUtil
          .copyList(picList, MdmProductMediaRespVo.class);
      mdmProductReqVo.setPictureList(mdmProductMediaRespVos);
    }
    mdmProductService.save(mdmProductReqVo);
  }

}
