package com.biz.crm.mdmbuglistmanagement.controller;

import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.mdmbuglistmanagement.service.IMdmBugListManagementService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * bug管理主表
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmbuglistmanagement")
@Api(tags = "bug管理主表")
public class MdmBugListManagementController {
    @Autowired
    private IMdmBugListManagementService mdmBugListManagementService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<MdmBugListManagementRespVo>> list(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo) {
        PageResult<MdmBugListManagementRespVo> result=mdmBugListManagementService.findList(mdmBugListManagementReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<MdmBugListManagementRespVo> query(@RequestParam(value = "id", required = false) String id) {
        MdmBugListManagementRespVo respVo=mdmBugListManagementService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo) {
        mdmBugListManagementService.save(mdmBugListManagementReqVo);
        return Result.ok("操作成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo) {
        mdmBugListManagementService.update(mdmBugListManagementReqVo);
        return Result.ok("操作成功");
    }


    /**
     * 批量删除
     */
    @ApiOperation(value = "批量删除")
    @PostMapping("/batchDelete")
    @CrmLog
    public Result batchDelete(@RequestBody List<String> ids){
        mdmBugListManagementService.batchDelete(ids);
        return Result.ok("操作成功");
    }
    /**
     * 批量紧急
     */
    @ApiOperation(value = "批量紧急")
    @PostMapping("/batchUrgent")
    @CrmLog
    public Result batchUrgent(@RequestBody List<String> ids){
        mdmBugListManagementService.batchUrgent(ids);
        return Result.ok("操作成功");
    }
    /**
     * 后端批量解决
     */
    @ApiOperation(value = "后端批量解决")
    @PostMapping("/batchBackEndFix")
    @CrmLog
    public Result batchBackEndFix(@RequestBody List<String> ids){
        mdmBugListManagementService.batchBackEndFix(ids);
        return Result.ok("操作成功");
    }

    /**
     * 前端批量解决
     */
    @ApiOperation(value = "前端批量解决")
    @PostMapping("/batchForeEndFix")
    @CrmLog
    public Result batchForeEndFix(@RequestBody List<String> ids){
        mdmBugListManagementService.batchForeEndFix(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量发布远程仓库
     */
    @ApiOperation(value = "批量发布远程仓库")
    @PostMapping("/batchComplete")
    @CrmLog
    public Result batchComplete(@RequestBody List<String> ids){
        mdmBugListManagementService.batchComplete(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量dev 测试中
     */
    @ApiOperation(value = "批量dev 测试中")
    @PostMapping("/batchDevTest")
    @CrmLog
    public Result batchDevTest(@RequestBody List<String> ids){
        mdmBugListManagementService.batchDevTest(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量dev 测试通过
     */
    @ApiOperation(value = "批量dev 测试通过")
    @PostMapping("/batchDevTestPass")
    @CrmLog
    public Result batchDevTestPass(@RequestBody List<String> ids){
        mdmBugListManagementService.batchDevTestPass(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量uat 测试通过
     */
    @ApiOperation(value = "批量 uat测试通过")
    @PostMapping("/batchUatTestPass")
    @CrmLog
    public Result batchUatTestPass(@RequestBody List<String> ids){
        mdmBugListManagementService.batchUatTestPass(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量uat 测试中
     */
    @ApiOperation(value = "批量 uat测试中")
    @PostMapping("/batchUatTest")
    @CrmLog
    public Result batchUatTest(@RequestBody List<String> ids){
        mdmBugListManagementService.batchUatTest(ids);
        return Result.ok("操作成功");
    }
    /**
     * 批量pro 测试中
     */
    @ApiOperation(value = "批量 pro测试中")
    @PostMapping("/batchProTest")
    @CrmLog
    public Result batchProTest(@RequestBody List<String> ids){
        mdmBugListManagementService.batchProTest(ids);
        return Result.ok("操作成功");
    }
    /**
     * 批量pro 测试通过
     */
    @ApiOperation(value = "批量 pro 测试通过")
    @PostMapping("/batchProTestPass")
    @CrmLog
    public Result batchProTestPass(@RequestBody List<String> ids){
        mdmBugListManagementService.batchProTestPass(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量 前端部署到 pro
     */
    @ApiOperation(value = "批量 前端部署到 pro")
    @PostMapping("/batchForeEndPro")
    @CrmLog
    public Result batchForeEndPro(@RequestBody List<String> ids){
        mdmBugListManagementService.batchForeEndPro(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量 后端端部署到 pro
     */
    @ApiOperation(value = "批量 后端端部署到 pro")
    @PostMapping("/batchBackEndPro")
    @CrmLog
    public Result batchBackEndPro(@RequestBody List<String> ids){
        mdmBugListManagementService.batchBackEndPro(ids);
        return Result.ok("操作成功");
    }
    /**
     * 批量 后端端部署到 uat
     */
    @ApiOperation(value = "批量 后端端部署到 uat")
    @PostMapping("/batchBackEndUat")
    @CrmLog
    public Result batchBackEndUat(@RequestBody List<String> ids){
        mdmBugListManagementService.batchBackEndUat(ids);
        return Result.ok("操作成功");
    }
    /**
     * 批量 前端部署到 uat
     */
    @ApiOperation(value = "批量 前端部署到 uat")
    @PostMapping("/batchForeEndUat")
    @CrmLog
    public Result batchForeEndUat(@RequestBody List<String> ids){
        mdmBugListManagementService.batchForeEndUat(ids);
        return Result.ok("操作成功");
    }
    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo) {
        mdmBugListManagementService.enableBatch(mdmBugListManagementReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  MdmBugListManagementReqVo mdmBugListManagementReqVo) {
        mdmBugListManagementService.disableBatch(mdmBugListManagementReqVo);
        return Result.ok("禁用成功");
    }
}
