package com.biz.crm.mdmbuglistmanagement.service;

import com.biz.crm.mdmbuglistmanagement.model.MdmBugListManagementEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;

import java.util.List;
import java.util.Map;

/**
 * bug管理主表接口
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
public interface IMdmBugListManagementService extends IService<MdmBugListManagementEntity> {

    /**
     * 列表
     * @param mdmBugListManagementReqVo
     * @return PageResult<MdmBugListManagementRespVo>
     */
    PageResult<MdmBugListManagementRespVo> findList(MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 查询
     * @param id
     * @return MdmBugListManagementRespVo
     */
    MdmBugListManagementRespVo query(String id);

    /**
     * 新增
     * @param mdmBugListManagementReqVo
     * @return
     */
    void save(MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 更新
     * @param mdmBugListManagementReqVo
     * @return
     */
    void update(MdmBugListManagementReqVo mdmBugListManagementReqVo);

//
    /**
     * 启用
     * @param mdmBugListManagementReqVo
     * @return
     */
    void enableBatch(MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 禁用
     * @param mdmBugListManagementReqVo
     * @return
     */
    void disableBatch(MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 批量 后端解决
     * @param ids ids
     */
    void batchBackEndFix(List<String> ids);

    /**
     * 批量 dev 测试中
     * @param ids ids
     */
    void batchDevTest(List<String> ids);

    /**
     * 批量 dev 测试通过
     * @param ids ids
     */
    void batchDevTestPass(List<String> ids);

    /**
     * 批量 前端解决
     * @param ids ids
     */
    void batchForeEndFix(List<String> ids);

    /**
     * 批量 发布到远程仓库
     * @param ids ids
     */
    void batchComplete(List<String> ids);

    /**
     * 批量uat 测试通过
     * @param ids ids
     */
    void batchUatTestPass(List<String> ids);

    /**
     * 批量 uat 测试中
     * @param ids ids
     */
    void batchUatTest(List<String> ids);

    /**
     *  批量 pro 测试中
     * @param ids ids
     */
    void batchProTest(List<String> ids);

    /**
     *  批量 pro 测试通过
     * @param ids ids
     */
    void batchProTestPass(List<String> ids);

    /**
     *  批量 前端部署到 uat
     * @param ids ids
     */
    void batchForeEndUat(List<String> ids);

    /**
     * 批量 后端部署到 uat
     * @param ids ids
     */
    void batchBackEndUat(List<String> ids);

    /**
     *  批量 后端部署到 pro
     * @param ids ids
     */
    void batchBackEndPro(List<String> ids);

    /**
     * 批量 前端部署到 pro
     * @param ids ids
     */
    void batchForeEndPro(List<String> ids);

    /**
     * 批量删除
     * @param ids ids
     */
    void batchDelete(List<String> ids);

    /**
     * 批量 紧急
     * @param ids
     */
    void batchUrgent(List<String> ids);
}

