package com.biz.crm.newhope.service;

import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.newhope.util.Body;

import java.io.UnsupportedEncodingException;

/**
 * @author maoshen
 * @date 2021/6/3.
 */
public interface OrgSyncService {
    /**
     * 组织同步
     * 带页码cookie
     *
     * @param reqVo
     * @return
     */
    Body orgSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException;

    /**
     * 全量组织数据同步
     *
     * @param reqVo
     * @throws UnsupportedEncodingException
     */
    void orgSyncAll(NewHopeReqVo reqVo) throws UnsupportedEncodingException;

    /**
     * 增量组织数据同步
     *
     * @param reqVo
     */
    void orgSyncIncrement(NewHopeReqVo reqVo) throws UnsupportedEncodingException;
}
