package com.biz.crm.newhope.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.nebular.mdm.newhope.resp.NewHopeRespVo;
import com.biz.crm.newhope.service.UserSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.newhope.util.HopeResult;
import com.biz.crm.newhope.util.NewHopeUtils;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.*;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/6/3.
 */
@Slf4j
@Service
public class UserSyncServiceImpl implements UserSyncService {

    @Autowired
    private MdmUserService mdmUserService;

    @Resource
    private MdmUserMapper mdmUserMapper;

    private static AtomicInteger count = new AtomicInteger();

    /**
     * 用户同步
     *
     * @param reqVo
     * @return
     */
    @Override
    public Body userSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        AssertUtils.isNotEmpty(reqVo.getFilter(), "同步方式不能为空");
        AssertUtils.isTrue(!FilterEnum.needOrgUrlSet().contains(reqVo.getFilter()), "用户同步方式与Url不匹配");
        if (StringUtils.equals(reqVo.getFilter(), FilterEnum.INCREMENT_USER.getCode())) {
            AssertUtils.isNotEmpty(reqVo.getIncrementTime(), "查询用户增量，增量时间不能为空");
        }
        NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
        // 设置请求头 headers
        Map<String, String> headers = getStringStringMap(respVo);
        Result<String> result = HttpClientUtils.doGet(respVo.getUrl(), headers);
        HopeResult hopeResult = JsonPropertyUtil.toObject(result.getResult(), HopeResult.class);
        if (hopeResult == null) {
            return new Body();
        }
        return hopeResult.getBody();
    }

    /**
     * 用户同步
     *
     * @param reqVo
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void userSync(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        log.info("用户全量同步开始");
        reqVo.setFilter(FilterEnum.USER.getCode());
        // 全量同步编码校验
        Set<String> userNameSet = Sets.newHashSet();
        String cookie = "";
        while ("".equals(cookie) || (cookie != null && cookie.length() > 1)) {
            cookie = null;
            Set<String> userNameSetByCookie = Sets.newHashSet();
            List<MdmUserEntity> needSaveList = Lists.newArrayList();
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
            // 设置请求头 headers
            Map<String, String> headers = getStringStringMap(respVo);
            Result<String> result = HttpClientUtils.doGet(respVo.getUrl(), headers);
            // 忽略短横线 "_"
            HopeResult hopeResult = JsonPropertyUtil.toObject(ApiResultUtil.objResult(result, true), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getUsers())) {
                return;
            }
            hopeResult.getBody().getUsers().forEach(x -> {
                if (StringUtils.isBlank(x.getUserId())) {
                    return;
                }
                if (!userNameSet.contains(x.getUserId())) {
                    MdmUserEntity entity = new MdmUserEntity();
                    entity.setFullName(x.getUserCn());
                    entity.setUserName(x.getUserId());
                    entity.setUserPassword(x.getUserpassword());
                    entity.setId(x.getUserId());
                    entity.setUserCode(x.getUserId());
                    entity.setUserType(UserTypeEnum.USER.getCode());
                    entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                    entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
                    entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    entity.setUserPhone(x.getMobile());
                    entity.setStartTime(DateUtil.formatDate() + " " + DateUtil.formatShortTime());
                    entity.setEndTime("9999-12-31 23:59:59");
                    needSaveList.add(entity);
                    userNameSetByCookie.add(x.getUserId());
                    userNameSet.add(x.getUserId());
                }
            });
            reqVo.setCookie(hopeResult.getBody().getCookie());
            // 检验本页同步是否重复
            if (CollectionUtils.isNotEmpty(userNameSetByCookie)) {
                List<MdmUserEntity> entitiesByDb = mdmUserMapper.selectList(Wrappers.<MdmUserEntity>lambdaQuery()
                        .in(MdmUserEntity::getUserName, userNameSetByCookie));
                this.saveOrUpdateUserList(needSaveList, entitiesByDb);
            }
            cookie = hopeResult.getBody().getCookie();
        }
        log.info("用户全量结束");
        log.info("共同步" + count.get() + "条用户数据");
    }

    /**
     * 新增或修改
     *
     * @param needSaveList
     * @param entitiesByDb
     */
    private void saveOrUpdateUserList(List<MdmUserEntity> needSaveList, List<MdmUserEntity> entitiesByDb) {
        if (CollectionUtils.isEmpty(needSaveList)) {
            return;
        }
        List<MdmUserEntity> saveEntities = Lists.newArrayList();
        List<MdmUserEntity> updateEntities = Lists.newArrayList();
        if (CollectionUtils.isEmpty(entitiesByDb)) {
            //mdmUserService.saveOrUpdateBatch(needSaveList);
            saveEntities = needSaveList;
            mdmUserService.saveBatch(saveEntities);
            count.getAndAdd(saveEntities.size());
            return;
        }
        Set<String> codeSet = entitiesByDb.stream().map(MdmUserEntity::getUserName)
                .collect(Collectors.toSet());
        List<MdmUserEntity> finalSaveEntities = Lists.newArrayList();
        needSaveList.forEach(x -> {
            if (codeSet.contains(x.getUserName())) {
                updateEntities.add(x);
            } else {
                finalSaveEntities.add(x);
            }
        });
        mdmUserService.saveBatch(finalSaveEntities);
        count.getAndAdd(finalSaveEntities.size());
        mdmUserService.updateBatchById(updateEntities);
        count.getAndAdd(updateEntities.size());
    }

    private Map<String, String> getStringStringMap(NewHopeRespVo respVo) {
        Map<String, String> headers = Maps.newHashMap();
        headers.put("sign", respVo.getSign());
        headers.put("encodekey", respVo.getEncodekey());
        headers.put("randomcode", respVo.getRandomcode());
        headers.put("appuser", respVo.getAppuser());
        headers.put("timestamp", respVo.getTimestamp());
        return headers;
    }


    /**
     * 用户同步
     * 增量同步
     *
     * @param reqVo
     */
    @Override
    public void userSyncIncrement(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        log.info("用户增量同步开始");
        reqVo.setFilter(FilterEnum.INCREMENT_USER.getCode());
        if (StringUtils.isBlank(reqVo.getIncrementTime())) {
            reqVo.setIncrementTime(new SimpleDateFormat("yyyy-MM-dd").format(DateUtil.yesterday()) + " " + DateUtil.DAY_EARLIEST_TIME);
        }
        reqVo.setIncrementTime(format(reqVo.getIncrementTime()) + "Z");
        Set<String> codesAll = Sets.newHashSet();
        String cookie = "";
        while ("".equals(cookie) || (cookie != null && cookie.length() > 1)) {
            cookie = null;
            List<MdmUserEntity> mdmUserEntities = Lists.newArrayList();
            Set<String> codesByCookie = Sets.newHashSet();
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
            Map<String, String> headers = getStringStringMap(respVo);
            Result<String> result = HttpClientUtils.doGet(respVo.getUrl(), headers);
            HopeResult hopeResult = JsonPropertyUtil.toObject(ApiResultUtil.objResult(result, true), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getUsers())) {
                return;
            }
            hopeResult.getBody().getUsers().forEach(x -> {
                if (StringUtils.isBlank(x.getUserId())) {
                    return;
                }
                if (codesByCookie.contains(x.getUserId())) {
                    throw new BusinessException(x.getUserId() + "待导入数据重复");
                }
                MdmUserEntity entity = new MdmUserEntity();
                entity.setFullName(x.getUserCn());
                entity.setUserName(x.getUserId());
                entity.setUserPassword(x.getUserpassword());
                entity.setId(x.getUserId());
                entity.setUserCode(x.getUserId());
                entity.setUserType(UserTypeEnum.USER.getCode());
                entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
                entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                entity.setUserPhone(x.getMobile());
                entity.setStartTime(DateUtil.formatDate() + " " + DateUtil.formatShortTime());
                entity.setEndTime("9999-12-31 23:59:59");
                mdmUserEntities.add(entity);
                codesByCookie.add(x.getUserId());
            });
            if (CollectionUtils.isNotEmpty(codesByCookie)) {
                List<MdmUserEntity> entitiesByDb = mdmUserMapper.selectList(Wrappers.<MdmUserEntity>lambdaQuery()
                        .in(MdmUserEntity::getUserName, codesByCookie));
                this.saveOrUpdateUserList(mdmUserEntities, entitiesByDb);
            }
            reqVo.setCookie(hopeResult.getBody().getCookie());
            cookie = reqVo.getCookie();
        }
        log.info("用户全量结束");
        log.info("共同步" + count.get() + "条用户数据");
    }

    /**
     * 忽略标点符号；
     *
     * @param s
     * @return
     */
    public static String format(String s) {
        String str = s.replaceAll("[`qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……& amp;*（）——+|{}【】‘；：”“’。，、？|-]", "");
        return str;
    }


}
