package com.biz.crm.newhope.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.nebular.mdm.newhope.resp.NewHopeRespVo;
import com.biz.crm.newhope.config.NewHopeConfig;
import com.biz.crm.utils.VerificationUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author maoshen
 * @date 2021/6/2.
 */
@Slf4j
@Component
public class NewHopeUtils {

    @Resource
    private NewHopeConfig newHopeConfig;

    private static final NewHopeUtils instance = new NewHopeUtils();

    @PostConstruct
    public void init() {
        instance.newHopeConfig = newHopeConfig;
    }

    public static NewHopeRespVo getNewHopeRespVo(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        NewHopeRespVo vo = new NewHopeRespVo();
        if (instance.newHopeConfig == null) {
            throw new BusinessException("配置异常");
        }
        // 访问filter
        if (!FilterEnum.getFilters().containsKey(reqVo.getFilter())) {
            return vo;
        }
        String replaceStr = StringUtils.replace(FilterEnum.getFilters().get(reqVo.getFilter()), "incrementTime", reqVo.getIncrementTime());
        // URL 编码%28orgId%3D*%29
        String filterStr = URLEncoder.encode(replaceStr,"UTF-8");
        String uri = MessageFormat.format(instance.newHopeConfig.getOrguri(),filterStr);
        if (!FilterEnum.needOrgUrlSet().contains(reqVo.getFilter())) {
            uri = MessageFormat.format(instance.newHopeConfig.getUseruri(),filterStr);
        }
        if(!StringUtils.isEmpty(reqVo.getCookie())){
            uri += reqVo.getCookie();
        }
        vo.setUrl(instance.newHopeConfig.getHost() + uri);
        vo.setSign(DigestUtils.md5Hex(StringUtils.join(uri , "&" , reqVo.getBody() , "&" , instance.newHopeConfig.getPrivatekey())));
        vo.setAppuser(instance.newHopeConfig.getAppuser());
        if (StringUtils.isNotBlank(reqVo.getOperator())) {
            vo.setOperator(reqVo.getOperator());
        } else {
            vo.setOperator(vo.getAppuser());
        }
        vo.setPrivatekey(instance.newHopeConfig.getPrivatekey());
        // 生成随机数
        vo.setRandomcode(VerificationUtil.generateRandomStr());
        // 获取时间戳
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        String date = df.format(new Date());
        vo.setTimestamp(date);
        vo.setEncodekey(DigestUtils.sha256Hex(StringUtils.join(vo.getAppuser(), vo.getRandomcode(),
                vo.getTimestamp(), "{", vo.getPrivatekey(), "}")));
        return vo;
    }
}
