package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.notice.service.IMdmNoticeCommentLikesService;
import com.biz.crm.notice.service.IMdmNoticeCommentService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公告评论
 *
 * @author yangshan
 * @date 2021-2-4 16:58:48
 */
@Slf4j
@RestController
@RequestMapping("/mdmNoticeCommentController")
@Api(tags = "公告评论管理")
public class MdmNoticeCommentController {

    @Autowired
    private IMdmNoticeCommentService mdmNoticeCommentService;
    @Autowired
    private IMdmNoticeCommentLikesService mdmNoticeCommentLikesService;
    /**
     * 列表
     */
    @ApiOperation(value = "查询评论列表")
    @PostMapping("/findCommentList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmNoticeCommentRespVo>> findCommentList(@RequestBody MdmNoticeCommentReqVo mdmNoticeCommentReqVo) {
        PageResult<MdmNoticeCommentRespVo> commentList = mdmNoticeCommentService.findCommentList(mdmNoticeCommentReqVo);
        return Result.ok(commentList);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增评论",httpMethod = "GET")
    @GetMapping("/save")
    @CrmLog
    public Result save(@RequestParam("id") String id, @RequestParam("commentText") String commentText) {
        mdmNoticeCommentService.save(id,commentText);
        return Result.ok();
    }

    /**
     * 新增
     */
    @ApiOperation(value = "评论可见状态",httpMethod = "GET")
    @GetMapping("/updateNoticeVisible")
    @CrmLog
    public Result updateNoticeVisible(@RequestParam("id") String id) {
        mdmNoticeCommentService.updateNoticeVisible(id);
        return Result.ok();
    }

    /**
     * 点赞
     */
    @ApiOperation(value = "点赞",httpMethod = "GET")
    @GetMapping("/like")
    @CrmLog
    public Result like(@RequestParam("commentId") String commentId) {
        mdmNoticeCommentLikesService.like(commentId);
        return Result.ok();
    }

    /**
     * 取消点赞
     */
    @ApiOperation(value = "取消点赞",httpMethod = "GET")
    @GetMapping("/cancelLike")
    @CrmLog
    public Result cancelLike(@RequestParam("commentId") String commentId) {
        mdmNoticeCommentLikesService.cancelLike(commentId);
        return Result.ok();
    }

    /**
     * 是否点过赞
     */
    @ApiOperation(value = "是否点过赞判断",httpMethod = "GET")
    @GetMapping("/doCheckLike")
    @CrmLog
    public Result doCheckLike(@RequestParam("commentId") String commentId) {
        boolean result = mdmNoticeCommentLikesService.doCheck(commentId);
        return Result.ok(result);
    }
}
