package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.service.IMdmNoticeService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * 公告管理 
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Slf4j
@RestController
@RequestMapping("/mdmNoticeController")
@Api(tags = "公告管理 ")
public class MdmNoticeController {
    @Autowired
    private IMdmNoticeService mdmNoticeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询公告列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmNoticeRespVo>> list(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        PageResult<MdmNoticeRespVo> result= mdmNoticeService.findList(mdmNoticeReqVo);
        return Result.ok(result);
    }


    /**
     * 列表
     */
    @ApiOperation(value = "首页公告列表")
    @PostMapping("/homePageList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmNoticeRespVo>> homePageList(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        PageResult<MdmNoticeRespVo> result= mdmNoticeService.homePageList(mdmNoticeReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "查询小程序列表")
    @PostMapping("/miniList")
    @CrmLog
    public Result<PageResult<MdmNoticeRespVo>> miniList(@RequestBody MdmNoticeMiniReqVo mdmNoticeMiniReqVo) {
        PageResult<MdmNoticeRespVo> result= mdmNoticeService.findListByMiniPrg(mdmNoticeMiniReqVo);
        return Result.ok(result);
    }

    /**
     * 最新单条
     */
    @ApiOperation(value = "查询公告单条最新")
    @GetMapping("/miniNewNotice")
    @CrmLog
    public Result<MdmNoticeRespVo> miniNewNotice(){
        MdmNoticeRespVo respVo = mdmNoticeService.queryMiniPrgNew();
        return Result.ok(respVo);
    }

    @ApiOperation(value = "小程序详情",httpMethod = "GET")
    @GetMapping("/miniQuery")
    @CrmLog
    public Result<MdmNoticeRespVo> miniQuery(@RequestParam String id) {
        MdmNoticeRespVo result= mdmNoticeService.queryMiniPrg(id);
        return Result.ok(result);
    }

    @ApiOperation(value = "小程序详情（上一页/下一页）",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "公告id", required = true, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "upBelow", value = "翻页状态(1:上一页,0:下一页)", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/miniQueryUpBelow")
    @CrmLog
    public Result<MdmNoticeRespVo> miniQueryUpBelow(@RequestParam("id") String id,@RequestParam("upBelow") String upBelow){
        MdmNoticeRespVo result= mdmNoticeService.queryMiniPrgByUpBelow(id,upBelow);
        return Result.ok(result);
    }


    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<MdmNoticeRespVo> query(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        MdmNoticeRespVo respVo= mdmNoticeService.query(mdmNoticeReqVo);
        return Result.ok(respVo);
    }


    /**
     * 查询公告详情
     */
    @ApiOperation(value = "查询公告详情",httpMethod = "GET")
    @GetMapping("/queryNoticeDetail")
    @CrmLog
    public Result<MdmNoticeRespVo> queryNoticeDetail(@RequestParam String id) {
        MdmNoticeReqVo mdmNoticeReqVo = new MdmNoticeReqVo();
        mdmNoticeReqVo.setId(id);
        MdmNoticeRespVo respVo= mdmNoticeService.query(mdmNoticeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 保存，发布公告
     */
    @ApiOperation(value = "保存和发布公告")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        mdmNoticeService.save(mdmNoticeReqVo);
        return Result.ok();
    }

    /**
     * 取消发布公告
     */
    @ApiOperation(value = "取消发布",httpMethod = "GET")
    @GetMapping("/cancelRelease")
    @CrmLog
    public Result cancelRelease(@RequestParam String id) {
        mdmNoticeService.cancelRelease(id);
        return Result.ok();
    }

    /**
     * 根据id发布
     */
    @ApiOperation(value = "根据id发布",httpMethod = "GET")
    @GetMapping("/releaseNoticeById")
    @CrmLog
    public Result releaseNoticeById(@RequestParam String id) {
        mdmNoticeService.releaseNoticeById(id);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        mdmNoticeService.update(mdmNoticeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除公告")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmNoticeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 小程序删除
     */
    @ApiOperation(value = "小程序删除公告",httpMethod = "GET")
    @GetMapping("/deleteById")
    @CrmLog
    public Result deleteById(@RequestParam String id) {
        mdmNoticeService.deleteById(id);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        mdmNoticeService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        mdmNoticeService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 置顶
     */
    @ApiOperation(value = "置顶",httpMethod = "GET")
    @GetMapping("/top")
    @CrmLog
    public Result top(@RequestParam String id){
        mdmNoticeService.top(id);
        return Result.ok();
    }

    /**
     * 取消置顶
     */
    @ApiOperation(value = "取消置顶",httpMethod = "GET")
    @GetMapping("/cancelTop")
    @CrmLog
    public Result cancelTop(@RequestParam String id){
        mdmNoticeService.cancelTop(id);
        return Result.ok();
    }

    /**
     * 角色判断
     */
    @ApiOperation(value = "角色判断")
    @PostMapping("/isNoticeAdmin")
    @CrmLog
    @CrmDictMethod
    public Result<Boolean> isNoticeAdmin() {
        return Result.ok(mdmNoticeService.isNoticeAdmin());
    }
}
