package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.notice.service.IMdmNoticeFileService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公告附件 
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@RestController
@RequestMapping("/mdmNoticeFileController")
@Api(tags = "公告附件 ")
public class MdmNoticeFileController {
    @Autowired
    private IMdmNoticeFileService mdmNoticeFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<MdmNoticeFileRespVo>> list(@RequestBody MdmNoticeFileReqVo mdmNoticeFileReqVo) {
        PageResult<MdmNoticeFileRespVo> result= mdmNoticeFileService.findList(mdmNoticeFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<MdmNoticeFileRespVo> query(@RequestBody MdmNoticeFileReqVo mdmNoticeFileReqVo) {
        MdmNoticeFileRespVo respVo= mdmNoticeFileService.query(mdmNoticeFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody MdmNoticeFileReqVo mdmNoticeFileReqVo) {
        mdmNoticeFileService.save(mdmNoticeFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody MdmNoticeFileReqVo mdmNoticeFileReqVo) {
        mdmNoticeFileService.update(mdmNoticeFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmNoticeFileService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody List<String> ids) {
        mdmNoticeFileService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody List<String> ids) {
        mdmNoticeFileService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
