package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.notice.service.IMdmNoticeReadService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公告读取信息 
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Slf4j
@RestController
@RequestMapping("/mdmNoticeReadController")
@Api(tags = "公告读取信息 ")
public class MdmNoticeReadController {
    @Autowired
    private IMdmNoticeReadService mdmNoticeReadService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<MdmNoticeReadRespVo>> list(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        PageResult<MdmNoticeReadRespVo> result= mdmNoticeReadService.findList(mdmNoticeReadReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<MdmNoticeReadRespVo> query(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        MdmNoticeReadRespVo respVo= mdmNoticeReadService.query(mdmNoticeReadReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "公告读取新增",httpMethod = "GET")
    @GetMapping("/readSign")
    @CrmLog
    public Result save(@RequestParam("noticeCode") String noticeCode) {
        mdmNoticeReadService.save(noticeCode);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        mdmNoticeReadService.update(mdmNoticeReadReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmNoticeReadService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        mdmNoticeReadService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        mdmNoticeReadService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
