package com.biz.crm.notice.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReceivingReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReceivingRespVo;
import com.biz.crm.notice.model.MdmNoticeReceivingEntity;

import java.util.List;

/**
 * 公告发布范围 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface IMdmNoticeReceivingService extends IService<MdmNoticeReceivingEntity> {

    /**
     * 列表
     * @param mdmNoticeReceivingReqVo
     *eturn PageResult<MdmNoticeReceivingRespVo>
     */
    PageResult<MdmNoticeReceivingRespVo> findList(MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo);

    /**
     * 查询
     * @param mdmNoticeReceivingReqVo
     * @return MdmNoticeReceivingRespVo
     */
    MdmNoticeReceivingRespVo query(MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo);

    /**
     * 新增
     * @param mdmNoticeReceivingReqVo
     * @return
     */
    void save(MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo);

    /**
     * 更新
     * @param mdmNoticeReceivingReqVo
     * @return
     */
    void update(MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

