package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.notice.mapper.MdmNoticeCommentLikesMapper;
import com.biz.crm.notice.mapper.MdmNoticeCommentMapper;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import com.biz.crm.notice.model.MdmNoticeCommentLikesEntity;
import com.biz.crm.notice.service.IMdmNoticeCommentLikesService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * @author yangshan
 * @date 2021-2-5 19:46:35
 */
@Service
public class MdmNoticeCommentLikesServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmNoticeCommentLikesMapper, MdmNoticeCommentLikesEntity> implements IMdmNoticeCommentLikesService {
    @Resource
    private MdmNoticeCommentLikesMapper mdmNoticeCommentLikesMapper;
    @Resource
    private MdmNoticeCommentMapper mdmNoticeCommentMapper;

    /**
     * 统计点赞数
     * @param commentId
     * @return
     */
    @Override
    public Integer getTotalCommentLikes(String commentId) {
        return mdmNoticeCommentLikesMapper.getTotalCommentLikes(commentId);
    }

    /**
     * 点赞
     * @param commentId
     */
    @Override
    public void like(String commentId) {
        if (this.doCheck(commentId)){
            throw new BusinessException("您已经点过赞了！");
        }
        MdmNoticeCommentLikesEntity mdmNoticeCommentLikesEntity = new MdmNoticeCommentLikesEntity();
        mdmNoticeCommentLikesEntity.setCommentId(commentId);
        mdmNoticeCommentLikesMapper.insert(mdmNoticeCommentLikesEntity);
    }

    /**
     * 取消点赞
     * @param commentId
     */
    @Override
    public void cancelLike(String commentId) {
        if (!this.doCheck(commentId)){
            throw new BusinessException("您还没有点赞！");
        }
        QueryWrapper<MdmNoticeCommentLikesEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("comment_id", commentId)
                .eq("create_code",UserUtils.getUser().getUsername());
        mdmNoticeCommentLikesMapper.delete(queryWrapper);
    }

    /**
     * 点赞存在校验
     * @param commentId
     * @return
     */
    @Override
    public boolean doCheck(String commentId){
        AssertUtils.isNotEmpty(commentId, "评论id不能为空");
        //评论存在校验
        MdmNoticeCommentEntity noticeCommentEntity = mdmNoticeCommentMapper.selectById(commentId);
        Assert.notNull(noticeCommentEntity, "该评论可能已经被删除了");
        QueryWrapper<MdmNoticeCommentLikesEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("create_code",UserUtils.getUser().getUsername())
                .eq("comment_id", commentId);
        MdmNoticeCommentLikesEntity entity = mdmNoticeCommentLikesMapper.selectOne(queryWrapper);
        if (null == entity){
            return false;
        }
        String id = entity.getId();
        return StringUtils.isNotEmpty(id);
    }
}
