package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRegionReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRegionRespVo;
import com.biz.crm.org.service.MdmOrgRegionService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 组织和行政区域关联表
 *
 * @author Tao.Chen
 * @date 2020-11-17 10:42:46
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRegionController")
@Api(tags = "MDM-组织管理-关联行政区域")
@CrmGlobalLog
public class MdmOrgRegionController {

    @Autowired
    private MdmOrgRegionService mdmOrgRegionService;

    @ApiOperation(value = "查询组织关联的行政区域列表（不分页）")
    @PostMapping("/findOrgRegionList")
    public Result<List<MdmOrgRegionRespVo>> findOrgRegionList(@RequestBody MdmOrgRegionReqVo reqVo) {
        return Result.ok(mdmOrgRegionService.findOrgRegionList(reqVo));
    }

    @ApiOperation(value = "新增组织和行政区域关联关系")
    @PostMapping("/saveOrgRegion")
    public Result saveOrgRegion(@RequestBody MdmOrgRegionReqVo reqVo) {
        mdmOrgRegionService.saveOrgRegion(reqVo);
        return Result.ok();
    }
}
