package com.biz.crm.org.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.org.req.MdmOrgPageSelectReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.provider.MdmOrgProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 组织表
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmOrgMapper extends BaseMapper<MdmOrgEntity> {
    /**
     * 列表
     *
     * @param page
     * @param mdmOrgReqVo
     * @return
     */
    @SqlPrivilege(
            orgCode = "a.org_code",
            extPosSql = "select 1 from mdm_position where org_code=a.org_code and position_code in"
    )
    List<MdmOrgRespVo> findList(Page<MdmOrgRespVo> page, @Param("vo") MdmOrgReqVo mdmOrgReqVo);

    /**
     * 列表
     *
     * @param page
     * @param mdmOrgReqVo
     * @return
     */
    List<MdmOrgRespVo> findAllPage(Page<MdmOrgRespVo> page, @Param("vo") MdmOrgReqVo mdmOrgReqVo);

    @SqlPrivilege(
            orgCode = "a.org_code",
            extPosSql = "select 1 from mdm_position where org_code=a.org_code and position_code in"
    )
    List<MdmOrgRespVo> pageSelectList(Page<MdmOrgRespVo> page, @Param("vo") MdmOrgPageSelectReqVo reqVo);

    /**
     * 列表(provider)
     *
     * @param page
     * @param mdmOrgReqVo
     * @return
     */
    @SelectProvider(type = MdmOrgProvider.class,method = "findListProvider")
    @SqlPrivilege(orgCode = "a.org_code")
    List<MdmOrgRespVo> findListProvider(Page<MdmOrgRespVo> page, @Param("vo") MdmOrgReqVo mdmOrgReqVo);



    /**
     * 查询组织下拉框选择数据
     *
     * @param page
     * @param reqVo
     * @param underThisRuleCode    只查询当前降维编码全部下级组织
     * @param notUnderThisRuleCode 排除当前降维编码全部下级
     * @return
     */
    @SqlPrivilege(
            orgCode = "a.org_code",
            extPosSql = "select 1 from mdm_position where org_code=a.org_code and position_code in"
    )
    List<MdmOrgSelectRespVo> findOrgSelectList(Page<MdmOrgSelectRespVo> page, @Param("vo") MdmOrgSelectReqVo reqVo, @Param("underThisRuleCode") String underThisRuleCode, @Param("notUnderThisRuleCode") String notUnderThisRuleCode);

    /**
     * 查询条件下的组织，固定50条
     *
     * @param reqVo
     * @param rightLikeOrgRuleCodeList
     * @return
     */
    @SqlPrivilege(
            orgCode = "a.org_code",
            extPosSql = "select 1 from mdm_position where org_code=a.org_code and position_code in"
    )
    List<MdmOrgRespVo> findOrgAndChildrenList(Page<MdmOrgRespVo> page, @Param("vo") MdmOrgSearchReqVo reqVo,@Param("rightLikeOrgRuleCodeList") List<String> rightLikeOrgRuleCodeList);

    @SqlPrivilege(
            orgCode = "a1.org_code",
            extPosSql = "select 1 from mdm_position where org_code=a1.org_code and position_code in"
    )
    List<MdmOrgRespVo> findOrgChildrenByRuleCodeList(@Param("rightLikeOrgRuleCodeList") List<String> rightLikeOrgRuleCodeList);

    /**
     * 查询组织懒加载数据
     *
     * @param enableStatus    启用状态
     * @param topOnly         传true只查第一层
     * @param parentCode      只查询该编码下一级
     * @param codeList        只查询这些编码
     * @param ruleCodeList    只查询这些降维编码
     * @param excludeRuleCode 排除这个降维编码的下级
     * @return
     */
    @SqlPrivilege(
            orgCode = "org_code"
    )
    List<BaseLazyTreeRespVo> findOrgLazyTreeList(@Param("enableStatus") String enableStatus, @Param("topOnly") Boolean topOnly, @Param("parentCode") String parentCode, @Param("codeList") List<String> codeList, @Param("ruleCodeList") List<String> ruleCodeList, @Param("excludeRuleCode") String excludeRuleCode);

    /**
     * 把降维编码刷成id
     */
    void copyIdToRuleCode();

    /**
     * 把不存在的上级编码置成空
     */
    void setNullNotExistParentCode();

    /**
     * 查询全部组织
     * @return
     */
    List<MdmOrgRespVo> getAll();

}
