package com.biz.crm.org.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.org.req.MdmOrgPageSelectReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.*;
import com.biz.crm.org.model.MdmOrgEntity;

import java.util.List;
import java.util.Map;

/**
 * 组织表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmOrgService extends IService<MdmOrgEntity> {

    /**
     * 列表
     *
     * @param mdmOrgReqVo
     * @return PageResult<MdmOrgRespVo>
     */
    PageResult<MdmOrgRespVo> findList(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 列表
     *
     * @param mdmOrgReqVo
     * @return PageResult<MdmOrgRespVo>
     */
    PageResult<MdmOrgRespVo> findAllPage(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 组织分页选择列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmOrgRespVo> pageSelectList(MdmOrgPageSelectReqVo reqVo);

    /**
     * 根据id或者编码查询组织主表信息
     *
     * @param id
     * @param orgCode
     * @return MdmOrgRespVo
     */
    MdmOrgRespVo detail(String id, String orgCode);

    /**
     * 根据组织编码查询组织主表信息
     *
     * @param orgCode
     * @return
     */
    MdmOrgRespVo queryByOrgCode(String orgCode);

    /**
     * 根据组织编码批量查询组织主表
     *
     * @param orgCodeList
     * @return
     */
    List<MdmOrgRespVo> queryBatchByOrgCodeList(List<String> orgCodeList);

    /**
     * 获取组织编码名称map
     *
     * @param orgCodeList
     * @return
     */
    Map<String, String> getOrgCodeNameMap(List<String> orgCodeList);

    /**
     * 获取组织的降维编码
     *
     * @param orgCode
     * @return
     */
    String getOrgRuleCode(String orgCode);

    /**
     * 根据id或者编码集合批量查询组织主表信息
     *
     * @param ids
     * @param orgCodeList
     * @return
     */
    List<MdmOrgRespVo> detailBatch(List<String> ids, List<String> orgCodeList);

    /**
     * 根据组织编码集合获取组织详情redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    List<MdmOrgRedisVo> findRedisListByOrgCodeList(List<String> orgCodeList);

    /**
     * 根据组织编码集合获取组织上级redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    List<MdmOrgParentChildrenRedisVo> findRedisOrgParentListByCodeList(List<String> orgCodeList);

    /**
     * 根据组织编码集合获取组织下级redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    List<MdmOrgParentChildrenRedisVo> findRedisOrgChildrenListByCodeList(List<String> orgCodeList);

    /**
     * 获取全部组织redis缓存数据
     *
     * @return
     */
    List<MdmOrgReloadRedisVo> findRedisReloadList();

    /**
     * 新增
     *
     * @param mdmOrgReqVo
     * @return
     */
    void save(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 更新
     *
     * @param mdmOrgReqVo
     * @return
     */
    void update(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    @Deprecated
    void deleteBatch(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    @Deprecated
    void enableBatch(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    @Deprecated
    void disableBatch(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 选择组织下拉框列表
     *
     * @param reqVo
     * @return
     */
    List<MdmOrgSelectRespVo> findOrgSelectList(MdmOrgSelectReqVo reqVo);

    /**
     * 查询全部下级（含当前）组织列表
     *
     * @param orgId   组织id
     * @param orgCode 组织编码
     * @return list
     */
    List<MdmOrgRespVo> findAllChildrenOrgList(String orgId, String orgCode);

    /**
     * 批量查询组织全部下级组织
     *
     * @param ids
     * @param orgCodeList
     * @return
     */
    List<MdmOrgRespVo> findAllChildrenOrgListByList(List<String> ids, List<String> orgCodeList);

    /**
     * 查询全部下级（含当前）组织编码
     *
     * @param orgId   组织id
     * @param orgCode 组织编码
     * @return
     */
    List<String> findAllChildrenOrgCodeList(String orgId, String orgCode);

    /**
     * 批量查询下级组织编码集合
     *
     * @param ids
     * @param orgCodeList
     * @return
     */
    List<String> findAllChildrenOrgCodeListByList(List<String> ids, List<String> orgCodeList);

    /**
     * 查询当前组织的直接下级（不含当前）组织列表
     *
     * @param orgId
     * @param orgCode
     * @return
     */
    List<MdmOrgRespVo> findSingleChildrenOrgList(String orgId, String orgCode);

    /**
     * 查询全部上级（含当前）组织列表
     *
     * @param orgId   组织id
     * @param orgCode 组织编码
     * @return list
     */
    List<MdmOrgRespVo> findAllParentOrgList(String orgId, String orgCode);

    List<String> findAllParentOrgCodeList(String orgId, String orgCode);

    /**
     * 查询当前组织的直接上级组织
     *
     * @param orgId
     * @param orgCode
     * @return
     */
    MdmOrgRespVo findSingleParentOrg(String orgId, String orgCode);

    /**
     * 重置降维编码
     */
    void resetRuleCode();
    void resetRuleCode2();

    /**
     * 查询这些组织编码对应的组织，每个组织上附带这个组织（含下级组织）下的全部主职位
     *
     * @param orgCodeList
     * @return
     */
    List<MdmOrgWithPositionRespVo> findOrgWithAllPositionList(List<String> orgCodeList);

    /**
     * 查询这些组织编码对应的组织，每个组织上附带这个组织（不含下级组织）下的全部主职位
     *
     * @param orgCodeList
     * @return
     */
    List<MdmOrgWithPositionRespVo> findOrgWithSinglePositionList(List<String> orgCodeList);

    /**
     * @param reqVo
     * @return
     */
    List<MdmOrgRespVo> findOrgAndChildrenList(MdmOrgSearchReqVo reqVo);

    List<MdmOrgRespVo> listCondition(MdmOrgReqVo reqVo);

    /**
     * 查询组织，条件查询
     *
     * @param reqVo
     * @return
     */
    List<MdmOrgRespVo> findOrgList(MdmOrgReqVo reqVo);

    /**
     * 获取全部组织树形结构
     *
     * @return
     */
    List<MdmOrgTreeRespVo> getOrgTree();

    /**
     * 根据组织编码集合查询这些组织（不含自己）的上级组织编码，如果参数本身有上下级关系，则会返回处于上级的组织编码
     *
     * @param orgCodeList
     * @return
     */
    List<String> findAllParentOrgCodeExcludeSelf(List<String> orgCodeList);

    /**
     * 根据组织编码集合查询名称
     * @param orgCodeList 组织编码集合
     * @return map
     */
    Map<String,String> findOrgNameMap(List<String> orgCodeList);

    /**
     * 根据职位编码集合查询职位全部下级职位（不含自己，如果参数本身有上下级不做过滤）所在组织的全部下级组织（不含当前组织）
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    List<String> findAllChildrenOrgCodeListOfPositionChildrenList(List<String> positionCodeList);

    /**
     * 根据职位编码集合查询职位全部上级职位（不含自己，如果参数本身有上下级不做过滤）所在组织的全部上级组织（不含当前组织）
     *
     * @param positionCodeList
     * @return
     */
    List<String> findAllParentOrgCodeListOfPositionParentList(List<String> positionCodeList);

    /**
     * 组织搜索树
     * @param mdmOrgReqVo vo
     * @return list
     */
    List<MdmOrgTreeRespVo> orgSearchTree(MdmOrgReqVo mdmOrgReqVo);


    /**
     * 查询全部组织
     * @return
     */
    List<MdmOrgRespVo> getAll();

}

