package com.biz.crm.parametermanage.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.parametermanage.service.MdmParameterManageService;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 参数配置
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
@Slf4j
@RestController
@RequestMapping("/mdmParameterController")
@Api(tags = "全局参数")
@CrmGlobalLog
public class MdmParameterController {

    @Autowired
    private MdmParameterManageService mdmParameterManageService;

    @ApiOperation(value = "工具类使用，其它地方请勿使用")
    @PostMapping("/getParameterRedisList")
    public Result<List<ParameterVo>> getParameterRedisList(@RequestBody List<String> parameterCodeList) {
        return Result.ok(mdmParameterManageService.getParameterRedisList(parameterCodeList));
    }

    @PostMapping("/getParameterList")
    public Result<List<ParameterVo>> getParameterList(@RequestBody List<String> parameterCodeList) {
        return Result.ok(mdmParameterManageService.getParameterRedisList(parameterCodeList));
    }

    @ApiOperation(value = "根据全局参数编码获取参数当前值，从缓存查询，前端可以使用", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parameterCode", value = "全局参数编码", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/getParameterValue")
    public Result<String> getParameterValue(@RequestParam(value = "parameterCode", required = true) String parameterCode) {
        Result<String> result = new Result<>();
        result.setResult(ParamUtil.getParameterValue(parameterCode));
        return result;
    }
}
