package com.biz.crm.permission.manager;

import com.biz.crm.nebular.mdm.CrmExtTenObjVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.permission.service.IMdmDataPermissionExtendDetailService;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zxw
 * @date 2021-04-22 14:12
 **/
@Component
@ConditionalOnMissingBean(name = "MdmDataPermissionExpandContext")
public class MdmDataPermissionContext extends CrmExtTenObjVo {

    @Autowired(required = false)
    private List<MdmDataPermissionProcessor> mdmDataPermissionProcessors;

    public void save(MdmDataPermissionVo mdmDataPermissionVo) {
        if (mdmDataPermissionProcessors != null) {
            mdmDataPermissionProcessors.stream().forEach(x->x.save(mdmDataPermissionVo));
        }
    }

    public MdmDataPermissionVo populate(MdmDataPermissionVo mdmDataPermissionVo) {
        if (mdmDataPermissionProcessors != null) {
            mdmDataPermissionProcessors.stream().forEach(x->x.populate(mdmDataPermissionVo));
        }
        return mdmDataPermissionVo;
    }
}
