package com.biz.crm.permission.manager;

import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.eunm.mdm.PermissionResourceEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionDetailVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.permission.model.MdmDataPermissionExtendDetailEntity;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendDetailService;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PositionUtil;
import com.bizunited.platform.common.vo.UuidVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-04-22 14:16
 **/
@Service
@ConditionalOnMissingBean(name = "MdmDataPermissionOrgExpandProcessor")
@Slf4j
public class MdmDataPermissionOrgProcessor implements MdmDataPermissionProcessor {

    @Autowired
    private IMdmDataPermissionExtendService mdmDataPermissionExtendService;
    @Autowired
    private IMdmDataPermissionExtendDetailService mdmDataPermissionExtendDetailService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmDataPermissionVo mdmDataPermissionVo) {
        log.info("数据权限:保存：组织：入参:{}", JsonPropertyUtil.toJsonString(mdmDataPermissionVo));
        String functionCode = mdmDataPermissionVo.getFunctionCode();
        String listConfigCode = mdmDataPermissionVo.getListConfigCode();
        String roleCode = mdmDataPermissionVo.getRoleCode();
        List<MdmDataPermissionDetailVo> mdmDataPermissionDetailVos = mdmDataPermissionVo.getMdmDataPermissionDetailVos();
        if (CollectionUtils.isEmpty(mdmDataPermissionDetailVos)) {
            return;
        }
        //保存组织详情权限
        List<MdmDataPermissionExtendDetailEntity> extendDetailEntities = new ArrayList<>();
        List<MdmDataPermissionExtendEntity> entityList = mdmDataPermissionDetailVos.stream()
                .filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode()))
                .map(x -> {
                    MdmDataPermissionExtendEntity extendEntity = new MdmDataPermissionExtendEntity();
                    String id = UUID.randomUUID().toString();
                    extendEntity.setId(id);
                    extendEntity.setFunctionCode(functionCode);
                    extendEntity.setListConfigCode(listConfigCode);
                    extendEntity.setRoleCode(roleCode);
                    extendEntity.setPermissionObjCode(x.getPermissionObjCode());
                    extendEntity.setPermissionResource(x.getPermissionResource());
                    extendEntity.setPermissionSearchType(x.getPermissionSearchType());
                    if (PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource())) {
                        List<String> codeList = x.getDetailCodeList();
                        if (!CollectionUtils.isEmpty(codeList)) {
                            List<MdmOrgRespVo> orgList = OrgUtil.getOrgByCodeList(codeList);
                            if (!CollectionUtils.isEmpty(orgList)) {
                                String collect = orgList.stream().limit(3).map(MdmOrgRespVo::getOrgName)
                                        .collect(Collectors.joining(","));
                                extendEntity.setPermissionSearchType(collect);
                            }
                            for (String code : codeList) {
                                MdmDataPermissionExtendDetailEntity extendDetailEntity = new MdmDataPermissionExtendDetailEntity();
                                extendDetailEntity.setId(UUID.randomUUID().toString());
                                extendDetailEntity.setPermissionObjCode(MdmPermissionObjEnum.ORG.getCode());
                                extendDetailEntity.setDetailCode(code);
                                extendDetailEntity.setPermissionExtendId(id);
                                extendDetailEntities.add(extendDetailEntity);
                            }
                        }
                    }
                    return extendEntity;
                })
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        mdmDataPermissionExtendDetailService.add(extendDetailEntities);
        mdmDataPermissionExtendService.add(entityList);
    }

    @Override
    public void populate(MdmDataPermissionVo mdmDataPermissionVo) {
        List<MdmDataPermissionDetailVo> mdmDataPermissionDetailVos = mdmDataPermissionVo.getMdmDataPermissionDetailVos();
        if(CollectionUtils.isEmpty(mdmDataPermissionDetailVos)){
            return;
        }
        Map<String, String> map = DictUtil.dictMap("permission_obj_org");
        if (map != null && map.size() > 0) {
            for (MdmDataPermissionDetailVo mdmDataPermissionDetailVo : mdmDataPermissionDetailVos) {
                if (MdmPermissionObjEnum.ORG.getCode().equals(mdmDataPermissionDetailVo.getPermissionObjCode())) {
                    if (PermissionResourceEnum.PRESUPPOSITION.getCode().equals(mdmDataPermissionDetailVo.getPermissionResource())) {
                        String permissionSearchType = mdmDataPermissionDetailVo.getPermissionSearchType();
                        if(!StringUtils.isEmpty(permissionSearchType)){
                            mdmDataPermissionDetailVo.setPermissionSearchTypeName(map.get(permissionSearchType));
                        }
                    }
                }
            }
        }

        List<String> idList = mdmDataPermissionDetailVos.stream()
                .filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode()))
                .filter(x -> PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource()))
                .map(UuidVo::getId)
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        Map<String, List<String>> extendDetailMap = mdmDataPermissionExtendDetailService.lambdaQuery()
                .in(MdmDataPermissionExtendDetailEntity::getPermissionExtendId, idList)
                .eq(MdmDataPermissionExtendDetailEntity::getPermissionObjCode, MdmPermissionObjEnum.ORG.getCode())
                .select(MdmDataPermissionExtendDetailEntity::getDetailCode, MdmDataPermissionExtendDetailEntity::getPermissionExtendId)
                .list()
                .stream()
                .collect(Collectors.groupingBy(MdmDataPermissionExtendDetailEntity::getPermissionExtendId
                        , Collectors.mapping(MdmDataPermissionExtendDetailEntity::getDetailCode, Collectors.toList())));
        if (extendDetailMap == null || extendDetailMap.size() == 0) {
            return;
        }
        mdmDataPermissionDetailVos.forEach(x -> {
            List<String> list = extendDetailMap.get(x.getId());
            if (!CollectionUtils.isEmpty(list)) {
                x.setDetailCodeList(list);
                List<MdmOrgRespVo> orgList = OrgUtil.getOrgByCodeList(list);
                if (!CollectionUtils.isEmpty(orgList)) {
                    x.setDetailNameList(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.toList()));
                }
            }
        });
    }
}
