package com.biz.crm.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.permission.model.MdmCompetenceEntity;
import com.biz.crm.permission.model.MdmPermissionEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
public interface MdmPermissionMapper extends BaseMapper<MdmPermissionEntity> {
    /**
     * 列表
     *
     * @param page               page
     * @param mdmPermissionReqVo vo
     * @return list
     */
    List<MdmPermissionRespVo> findList(Page<MdmPermissionRespVo> page, @Param("vo") MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 查询菜单列表
     *
     * @param mdmPermissionModelReqVo vo
     * @return list
     */
    List<MdmCompetenceEntity> findMenuList(@Param("vo") MdmPermissionModelReqVo mdmPermissionModelReqVo);

    /**
     * 查询列表下拉框
     * @param mdmListConfigReqVo privilege
     * @return list
     */
    List<MdmListConfigRespVo> findConfigList(@Param("vo") MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 查询已配置菜单列表
     * @param mdmPermissionModelReqVo privilege
     * @return list
     */
    List<MdmPermissionSubModelRespVo> findConfigMenuList(@Param("vo") MdmPermissionModelReqVo mdmPermissionModelReqVo);

    /**
     * 查询公共字段菜单树
     *
     * @param mdmPermissionModelReqVo mdmPermissionModelReqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> findMenuTree(@Param("vo") MdmPermissionModelReqVo mdmPermissionModelReqVo);
}
