package com.biz.crm.permission.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 数据权限接口
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
public interface IMdmDataPermissionService extends IService<MdmDataPermissionEntity> {

    /**
     * 列表
     * @param mdmDataPermissionReqVo
     * @return PageResult<MdmDataPermissionRespVo>
     */
    PageResult<MdmDataPermissionRespVo> findList(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 查询
     * @param mdmDataPermissionReqVo
     * @return MdmDataPermissionRespVo
     */
    MdmDataPermissionRespVo query(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 新增
     * @param mdmDataPermissionReqVo
     * @return
     */
    void save(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 更新
     * @param mdmDataPermissionReqVo
     * @return
     */
    void update(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 删除
     * @param mdmDataPermissionReqVo
     * @return
     */
    void deleteBatch(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 启用
     * @param mdmDataPermissionReqVo
     * @return
     */
    void enableBatch(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 禁用
     * @param mdmDataPermissionReqVo
     * @return
     */
    void disableBatch(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     *
     * @param mdmDataPermissionReqVo
     * @return
     */
    MdmDataPermissionRespVo queryCondition(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 获取当前用户的数据权限
     * @return list
     */
    MdmCurrentPermissionRespVo currentUserDataPermission(String competenceCode,String listConfigCode);

    /**
     * 根据列表编码和菜单编码查询已配置的权限对象
     * @param functionCode 菜单编码
     * @param listConfigCode 列表编码
     * @return list
     */
    List<MdmPermissionObjRespVo> objList(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 根据查询对象获取查询方式列表
     * @param permissionObjCode 权限对象编码
     * @return map
     */
    Map<String, String> searchTypeList(String permissionObjCode);

    /**
     * 条件查询下拉框
     * @param mdmDataPermissionReqVo vo
     * @return vo
     */
    List<MdmFunctionRespVo> functionSelect(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 角色下拉框列表
     * @param mdmDataPermissionReqVo vo
     * @return list
     */
    List<MdmRoleRespVo> roleSelectList(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 功能列表下拉框
     * @param mdmDataPermissionReqVo vo
     * @return list
     */
    List<MdmListConfigRespVo> configList(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 菜单树
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> functionTree(MdmFunctionReqVo mdmFunctionReqVo);

    List<MdmPermissionSetVo> currentUserPermissionSql();

    /**
     * 更新当前及下级所有菜单数据权限
     * @param mdmDataPermissionReqVo vo
     */
    void updateAllSub(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 聚合查询配置权限的菜单编码与列表编码
     * @param mdmDataPermissionReqVo vo
     * @return map
     */
    Map<String, List<String>> findDataPermissionMap(MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 保存数据权限
     * @param mdmDataPermissionVo vo
     */
    void save(MdmDataPermissionVo mdmDataPermissionVo);

    /**
     * 查询详情
     * @param mdmDataPermissionVo vo
     * @return vo
     */
    MdmDataPermissionVo queryDetail(MdmDataPermissionVo mdmDataPermissionVo);


}

