package com.biz.crm.permission.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.permission.MdmListConfigReqVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.permission.model.MdmListConfigEntity;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
public interface IMdmListConfigService extends IService<MdmListConfigEntity> {

    /**
     * 列表
     * @param mdmListConfigReqVo
     * @return PageResult<MdmListConfigRespVo>
     */
    PageResult<MdmListConfigRespVo> findList(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 查询
     * @param mdmListConfigReqVo
     * @return MdmListConfigRespVo
     */
    MdmListConfigRespVo query(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 新增
     * @param mdmListConfigReqVo
     * @return
     */
    void save(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 更新
     * @param mdmListConfigReqVo
     * @return
     */
    void update(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 删除
     * @param mdmListConfigReqVo
     * @return
     */
    void deleteBatch(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 启用
     * @param mdmListConfigReqVo
     * @return
     */
    void enableBatch(MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 禁用
     * @param mdmListConfigReqVo
     * @return
     */
    void disableBatch(MdmListConfigReqVo mdmListConfigReqVo);

    List<MdmListConfigRespVo> listCondition(MdmListConfigReqVo mdmListConfigReqVo);
}

