package com.biz.crm.permission.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.function.MdmFunctionSelectReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionSelectRespVo;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.permission.model.MdmPermissionEntity;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
public interface IMdmPermissionService extends IService<MdmPermissionEntity> {

    /**
     * 列表
     *
     * @param mdmPermissionReqVo privilege
     * @return PageResult<MdmPermissionRespVo>
     */
    PageResult<MdmPermissionRespVo> findList(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 查询
     *
     * @param mdmPermissionReqVo privilege
     * @return MdmPermissionRespVo
     */
    MdmPermissionRespVo query(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 新增
     *
     * @param mdmPermissionReqVo privilege
     */
    void save(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 更新
     *
     * @param mdmPermissionReqVo privilege
     */
    void update(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 删除
     *
     * @param mdmPermissionReqVo privilege
     */
    void deleteBatch(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 启用
     *
     * @param mdmPermissionReqVo privilege
     */
    void enableBatch(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 禁用
     *
     * @param mdmPermissionReqVo privilege
     */
    void disableBatch(MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 查询列表名称
     *
     * @param mdmListConfigReqVo privilege
     * @return list
     */
    List<MdmListConfigRespVo> configList(MdmListConfigReqVo mdmListConfigReqVo);


    /**
     * 根据列表编码和菜单编码查询已配置的权限对象
     *
     * @param listConfigCode 列表编码
     * @param functionCode   菜单编码
     * @return list
     */
    List<MdmPermissionObjRespVo> configObjList(String listConfigCode, String functionCode);

    /**
     * 权限对象列表
     *
     * @param listConfigCode 列表编码
     * @param functionCode   菜单编码
     * @return list
     */
    List<MdmPermissionObjRespVo> objList(String listConfigCode, String functionCode);

    /**
     * 查询方式列表
     *
     * @param mdmPermissionSearchTypeVo privilege
     * @return list
     */
    List<MdmPermissionSearchTypeVo> searchTypeList(MdmPermissionSearchTypeVo mdmPermissionSearchTypeVo);

    /**
     * 保存权限列表
     *
     * @param mdmPermissionObjReqVo privilege
     */
    void saveObj(MdmPermissionObjReqVo mdmPermissionObjReqVo);


    /**
     * 系统菜单下拉框
     *
     * @param mdmFunctionSelectReqVo vo
     * @return list
     */
    List<MdmFunctionSelectRespVo> functionSelect(MdmFunctionSelectReqVo mdmFunctionSelectReqVo);
}

