package com.biz.crm.permission.service.impl;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.permission.mapper.MdmDataPermissionExtendDetailMapper;
import com.biz.crm.permission.model.MdmDataPermissionExtendDetailEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendDetailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 接口实现
 *
 * @author zxw
 * @date 2021-01-07 10:28:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmDataPermissionExtendDetailServiceExpandImpl")
public class MdmDataPermissionExtendDetailServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmDataPermissionExtendDetailMapper, MdmDataPermissionExtendDetailEntity> implements IMdmDataPermissionExtendDetailService {

    @Override
    public void add(List<MdmDataPermissionExtendDetailEntity> extendDetailEntities) {
        if(!CollectionUtils.isEmpty(extendDetailEntities)){
            this.saveBatch(extendDetailEntities);
        }
    }
}
