package com.biz.crm.poi.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiTypeTreeReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiTypeTreeRespVo;
import com.biz.crm.poi.service.MdmAmapPoiTypeService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Slf4j
@RestController
@RequestMapping("/mdmAmapPoiTypeController")
@Api(tags = "MDM-高德POI分类")
@CrmGlobalLog
public class MdmAmapPoiTypeController {

    @Resource
    private MdmAmapPoiTypeService mdmAmapPoiTypeService;

    @ApiOperation("懒加载树")
    @PostMapping("/lazyTree")
    public Result<List<MdmAmapPoiTypeTreeRespVo>> lazyTree(@RequestBody MdmAmapPoiTypeTreeReqVo reqVo) {
        return Result.ok(mdmAmapPoiTypeService.lazyTree(reqVo));
    }

}
