package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiCityTreeReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiCityTreeRespVo;
import com.biz.crm.poi.mapper.MdmAmapPoiCityMapper;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 高德地图城市表接口实现
 *
 * @author Tao.Chen
 * @date 2021-05-07 22:24:48
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmAmapPoiCityServiceExpandImpl")
public class MdmAmapPoiCityServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmAmapPoiCityMapper, MdmAmapPoiCityEntity> implements MdmAmapPoiCityService {

    @Resource
    private MdmAmapPoiCityMapper mdmAmapPoiCityMapper;
    @Resource
    private MdmRegionService mdmRegionService;

    @Override
    public List<MdmAmapPoiCityTreeRespVo> lazyTree(MdmAmapPoiCityTreeReqVo reqVo) {
        List<MdmAmapPoiCityTreeRespVo> list = new ArrayList<>();
        if (StringUtils.isEmpty(reqVo.getParentCode())) {
            list = mdmAmapPoiCityMapper.findFirstLevel();
        } else {
            list = mdmAmapPoiCityMapper.findListByParentCode(reqVo);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> regionCodeList = list.stream().filter(x -> StringUtils.isNotEmpty(x.getRegionCode())).map(MdmAmapPoiCityTreeRespVo::getRegionCode).collect(Collectors.toList());
            if (!regionCodeList.isEmpty()) {
                final Map<String, String> regionCodeNameMap = mdmRegionService.getRegionCodeNameMap(regionCodeList);
                if (!regionCodeNameMap.isEmpty()) {
                    list.forEach(item -> {
                        if (StringUtils.isNotEmpty(item.getRegionCode()) && regionCodeNameMap.containsKey(item.getRegionCode())) {
                            item.setRegionName(regionCodeNameMap.get(item.getRegionCode()));
                        }
                    });
                }
            }
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
        }
        return list;
    }

    @Override
    public List<String> getCityList() {
        Set<String> set = new HashSet<>(16);
        List<DictDataVo> dictList = DictUtil.list(DictConstant.MDM_AMAP_POI_CITY);
        if (CollectionUtil.listNotEmptyNotSizeZero(dictList)) {
            List<MdmAmapPoiCityEntity> list = this.lambdaQuery()
                    .in(MdmAmapPoiCityEntity::getAmapCode, dictList.stream().map(DictDataVo::getDictCode).collect(Collectors.toSet()))
                    .select(MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getParentCode)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                final Set<String> existParentCodeSet = list.stream().filter(x -> StringUtils.isNotEmpty(x.getParentCode())).map(MdmAmapPoiCityEntity::getParentCode).collect(Collectors.toSet());
                List<MdmAmapPoiCityEntity> collect = list.stream().filter(x -> !existParentCodeSet.contains(x.getAmapCode())).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {
                    this.getCityChildren(set, collect);
                }
            }
        }
        return new ArrayList<>(set);
    }

    protected void getCityChildren(Set<String> set, List<MdmAmapPoiCityEntity> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Set<String> listCodeSet = list.stream().map(MdmAmapPoiCityEntity::getAmapCode).collect(Collectors.toSet());
        List<MdmAmapPoiCityEntity> listChildren = this.lambdaQuery()
                .in(MdmAmapPoiCityEntity::getParentCode, listCodeSet)
                .select(MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getParentCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(listChildren)) {
            final Set<String> listChildrenParentCodeSet = listChildren.stream().filter(x -> StringUtils.isNotEmpty(x.getParentCode())).map(MdmAmapPoiCityEntity::getParentCode).collect(Collectors.toSet());
            set.addAll(listCodeSet.stream().filter(x -> !listChildrenParentCodeSet.contains(x)).collect(Collectors.toSet()));
            this.getCityChildren(set, listChildren);
        } else {
            set.addAll(listCodeSet);
        }
    }

}
