package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiDistanceRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.poi.mapper.MdmAmapPoiMapper;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmAmapPoiServiceExpandImpl")
public class MdmAmapPoiServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmAmapPoiMapper, MdmAmapPoiEntity> implements MdmAmapPoiService {

    @Resource
    private MdmAmapPoiMapper mdmAmapPoiMapper;

    @Override
    public PageResult<MdmAmapPoiRespVo> findAmapPoiList(MdmAmapPoiReqVo reqVo) {
        Page<MdmAmapPoiRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmAmapPoiRespVo> list = mdmAmapPoiMapper.findAmapPoiList(page, reqVo);
        return PageResult.<MdmAmapPoiRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmAmapPoiDistanceRespVo> findAmapPoiDistancePageList(MdmAmapPoiDistanceReqVo reqVo) {
        Assert.hasText(reqVo.getLongitude(), "缺失经度");
        Assert.hasText(reqVo.getLatitude(), "缺失纬度");
        Assert.hasText(reqVo.getDistance(), "缺失距离");
        if (new BigDecimal(reqVo.getDistance()).compareTo(new BigDecimal("50000")) > 0) {
            reqVo.setDistance("50000");
        }
        BigDecimal divide = new BigDecimal(reqVo.getDistance()).divide(new BigDecimal("111190"), 6, RoundingMode.HALF_UP);
        reqVo.setMaxLongitude(new BigDecimal(reqVo.getLongitude()).add(divide).toString());
        reqVo.setMinLongitude(new BigDecimal(reqVo.getLongitude()).subtract(divide).toString());
        reqVo.setMaxLatitude(new BigDecimal(reqVo.getLatitude()).add(divide).toString());
        reqVo.setMinLatitude(new BigDecimal(reqVo.getLatitude()).subtract(divide).toString());
        Page<MdmAmapPoiDistanceRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmAmapPoiDistanceRespVo> list = mdmAmapPoiMapper.findAmapPoiDistancePageList(page, reqVo);
        return PageResult.<MdmAmapPoiDistanceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType() {
        return mdmAmapPoiMapper.statisticalType();
    }

}

